//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log:	int-convolutions.desc,v $
// Revision 1.3  93/05/27  11:41:13  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:44:57  thoth
// New more descriptive names for standard convolutions.
// 
// Revision 1.1  93/03/18  11:23:20  thoth
// Initial revision
// 
// int linear_product int int zero=0
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	absorber,v $
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_IntPoint membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

#ifndef zero_extend_scan_int
#define zero_extend_scan_int

static void zero_extend_vec_scan(const IA_SetStructure &ss,
				 const int **src,
				 int **dest,
				 int zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    (*src) += temp.count;
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    for (unsigned j=0; j<temp.count; j++) {
		*((*dest)++) = *((*src)++);
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_vec_scan(temp.substructure, src, dest, zero);
	}
    }
}

static void zero_extend_iter_scan(const IA_SetStructure &ss,
				  IA_DIVIter<int> *srciter,
				  int **dest,
				  int zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    int	blah;
	    for (unsigned j=0; j<temp.count; j++) 
		(*srciter)(blah);
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    int	blah;
	    for (unsigned j=0; j<temp.count; j++) {
		(*srciter)(blah);
		*((*dest)++) = blah;
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_iter_scan(temp.substructure, srciter, dest, zero);
	}
    }
}

static void zero_extend(const IA_IntDiscreteImage &srcimg,
			const IA_IntPointSet &dest_ps, int *dest_data,
			int zero)
{
    IA_SetStructure	ss;
    intersect_with_dualstruct(srcimg.domain(), dest_ps, &ss);

    if (srcimg.type() == IA_VectorDI<int>::s_type()) {
	int	*srcdata = ((IA_VectorDI<int>*)srcimg.bdip)->vec;
	zero_extend_vec_scan(ss, &srcdata, &dest_data, zero);
    } else {
	IA_DIVIter<int>	iter(srcimg);
	zero_extend_iter_scan(ss, &iter, &dest_data, zero);
    }
}

#endif

static IA_IntDiscreteImage
linear_product_inv_core(IA_IntPoint src_infimum,
	      IA_IntPoint src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_IntDiscreteImage &templ,
	      IA_IntPointSet dest_ps)
{
    const int	dimen = src_width.dim();

    IA_IntPointSet	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_DIPIter<int>	iter(templ);
	IA_IntPoint	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_IPSIter	iter(dest_ps);
    IA_IntPoint	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a = 0; ;

	for (i=0; i<templ_sz; i++) {
	    a += (base[templ_offsets[i]]) * (templ_data[i]); ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_IntDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_IntDiscreteImage
linear_product_inv(const IA_IntDiscreteImage &img,
	 const IA_IntDiscreteImage &invtempl,
	 IA_IntPointSet dest_ps)
{
    IA_IntPoint	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_IntPoint	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_IntPointSet	src_ps = IA_IntPointSet(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, src_data, 0);
    IA_IntDiscreteImage	rval =
	linear_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_IntDiscreteImage linear_product(const IA_IntDiscreteImage &img,
			     const IA_IntDDTemplate &templ,
			     IA_IntPointSet dest_ps)
{
    if (templ.type() == IA_InvariantDT<IA_IntDiscreteImage >::s_type()) {
	return linear_product_inv(img, ((IA_InvariantDT<IA_IntDiscreteImage >*)templ.bdtp)->value, dest_ps);
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_IPSIter	dest_iter(dest_ps);
	IA_IntPoint	base_ip;
	while (dest_iter(base_ip)) {
	    IA_IntDiscreteImage	tv = templ(base_ip);

	    IA_DIPIter<int>	templ_iter(tv);
	    IA_IntPoint	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a = 0; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_IntPoint	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		a += img(ip) * templ_val; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_IntDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
    }
}
// int addmax_product int int zero=-MAXINT
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	absorber,v $
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_IntPoint membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

#ifndef zero_extend_scan_int
#define zero_extend_scan_int

static void zero_extend_vec_scan(const IA_SetStructure &ss,
				 const int **src,
				 int **dest,
				 int zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    (*src) += temp.count;
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    for (unsigned j=0; j<temp.count; j++) {
		*((*dest)++) = *((*src)++);
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_vec_scan(temp.substructure, src, dest, zero);
	}
    }
}

static void zero_extend_iter_scan(const IA_SetStructure &ss,
				  IA_DIVIter<int> *srciter,
				  int **dest,
				  int zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    int	blah;
	    for (unsigned j=0; j<temp.count; j++) 
		(*srciter)(blah);
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    int	blah;
	    for (unsigned j=0; j<temp.count; j++) {
		(*srciter)(blah);
		*((*dest)++) = blah;
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_iter_scan(temp.substructure, srciter, dest, zero);
	}
    }
}

static void zero_extend(const IA_IntDiscreteImage &srcimg,
			const IA_IntPointSet &dest_ps, int *dest_data,
			int zero)
{
    IA_SetStructure	ss;
    intersect_with_dualstruct(srcimg.domain(), dest_ps, &ss);

    if (srcimg.type() == IA_VectorDI<int>::s_type()) {
	int	*srcdata = ((IA_VectorDI<int>*)srcimg.bdip)->vec;
	zero_extend_vec_scan(ss, &srcdata, &dest_data, zero);
    } else {
	IA_DIVIter<int>	iter(srcimg);
	zero_extend_iter_scan(ss, &iter, &dest_data, zero);
    }
}

#endif

static IA_IntDiscreteImage
addmax_product_inv_core(IA_IntPoint src_infimum,
	      IA_IntPoint src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_IntDiscreteImage &templ,
	      IA_IntPointSet dest_ps)
{
    const int	dimen = src_width.dim();

    IA_IntPointSet	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_DIPIter<int>	iter(templ);
	IA_IntPoint	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_IPSIter	iter(dest_ps);
    IA_IntPoint	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=-MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    int temp = (base[templ_offsets[i]])+(templ_data[i]); if (temp > a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_IntDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_IntDiscreteImage
addmax_product_inv(const IA_IntDiscreteImage &img,
	 const IA_IntDiscreteImage &invtempl,
	 IA_IntPointSet dest_ps)
{
    IA_IntPoint	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_IntPoint	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_IntPointSet	src_ps = IA_IntPointSet(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, src_data, -MAXINT);
    IA_IntDiscreteImage	rval =
	addmax_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_IntDiscreteImage addmax_product(const IA_IntDiscreteImage &img,
			     const IA_IntDDTemplate &templ,
			     IA_IntPointSet dest_ps)
{
    if (templ.type() == IA_InvariantDT<IA_IntDiscreteImage >::s_type()) {
	return addmax_product_inv(img, ((IA_InvariantDT<IA_IntDiscreteImage >*)templ.bdtp)->value, dest_ps);
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_IPSIter	dest_iter(dest_ps);
	IA_IntPoint	base_ip;
	while (dest_iter(base_ip)) {
	    IA_IntDiscreteImage	tv = templ(base_ip);

	    IA_DIPIter<int>	templ_iter(tv);
	    IA_IntPoint	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a=-MAXINT; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_IntPoint	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		int temp = img(ip)+templ_val; if (temp > a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_IntDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
    }
}
// double addmax double double zero=-MAXDOUBLE
// init:	RTYPE	a=-MAXDOUBLE;
// accum:	RTYPE temp = IVAL+TVAL; if (temp > a) a = temp;
// final:	IRESULT = a;
//
// int addmin_product int int  zero=MAXINT
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	absorber,v $
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_IntPoint membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

#ifndef zero_extend_scan_int
#define zero_extend_scan_int

static void zero_extend_vec_scan(const IA_SetStructure &ss,
				 const int **src,
				 int **dest,
				 int zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    (*src) += temp.count;
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    for (unsigned j=0; j<temp.count; j++) {
		*((*dest)++) = *((*src)++);
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_vec_scan(temp.substructure, src, dest, zero);
	}
    }
}

static void zero_extend_iter_scan(const IA_SetStructure &ss,
				  IA_DIVIter<int> *srciter,
				  int **dest,
				  int zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    int	blah;
	    for (unsigned j=0; j<temp.count; j++) 
		(*srciter)(blah);
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    int	blah;
	    for (unsigned j=0; j<temp.count; j++) {
		(*srciter)(blah);
		*((*dest)++) = blah;
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_iter_scan(temp.substructure, srciter, dest, zero);
	}
    }
}

static void zero_extend(const IA_IntDiscreteImage &srcimg,
			const IA_IntPointSet &dest_ps, int *dest_data,
			int zero)
{
    IA_SetStructure	ss;
    intersect_with_dualstruct(srcimg.domain(), dest_ps, &ss);

    if (srcimg.type() == IA_VectorDI<int>::s_type()) {
	int	*srcdata = ((IA_VectorDI<int>*)srcimg.bdip)->vec;
	zero_extend_vec_scan(ss, &srcdata, &dest_data, zero);
    } else {
	IA_DIVIter<int>	iter(srcimg);
	zero_extend_iter_scan(ss, &iter, &dest_data, zero);
    }
}

#endif

static IA_IntDiscreteImage
addmin_product_inv_core(IA_IntPoint src_infimum,
	      IA_IntPoint src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_IntDiscreteImage &templ,
	      IA_IntPointSet dest_ps)
{
    const int	dimen = src_width.dim();

    IA_IntPointSet	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_DIPIter<int>	iter(templ);
	IA_IntPoint	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_IPSIter	iter(dest_ps);
    IA_IntPoint	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    register int ival = (base[templ_offsets[i]]); if (ival == MAXINT) continue; int temp = ival+(templ_data[i]); if (temp < a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_IntDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_IntDiscreteImage
addmin_product_inv(const IA_IntDiscreteImage &img,
	 const IA_IntDiscreteImage &invtempl,
	 IA_IntPointSet dest_ps)
{
    IA_IntPoint	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_IntPoint	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_IntPointSet	src_ps = IA_IntPointSet(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, src_data, MAXINT);
    IA_IntDiscreteImage	rval =
	addmin_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_IntDiscreteImage addmin_product(const IA_IntDiscreteImage &img,
			     const IA_IntDDTemplate &templ,
			     IA_IntPointSet dest_ps)
{
    if (templ.type() == IA_InvariantDT<IA_IntDiscreteImage >::s_type()) {
	return addmin_product_inv(img, ((IA_InvariantDT<IA_IntDiscreteImage >*)templ.bdtp)->value, dest_ps);
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_IPSIter	dest_iter(dest_ps);
	IA_IntPoint	base_ip;
	while (dest_iter(base_ip)) {
	    IA_IntDiscreteImage	tv = templ(base_ip);

	    IA_DIPIter<int>	templ_iter(tv);
	    IA_IntPoint	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a=MAXINT; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_IntPoint	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		int temp = img(ip)+templ_val; if (temp < a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_IntDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
    }
}
// double addmin double double
// init:	RTYPE	a=MAXDOUBLE;
// accum:	RTYPE temp = IVAL+TVAL; if (temp < a) a = temp;
// final:	IRESULT = a;
//
