// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


static char DDTempl_rcsid[] = "$Id: DDTempl.c,v 1.3 93/05/27 11:28:18 thoth Exp $";

//
// $Log:	DDTempl.c,v $
// Revision 1.3  93/05/27  11:28:18  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:10:04  thoth
// Templates are now separate from images.
// 
// Revision 1.1  93/03/18  11:02:14  thoth
// Initial revision
// 

#include "DDTempl.h"
#include "IntPointSet.h"
#include "InvariantDT.h"
#include "FunctionDT.h"
#include "OtherDT.h"



template <class I>
void IA_DDTemplate<I>::set_and_reference_template(IA_BaseDT<I> *t)
{
    t->incr_ref();
    this->bdtp = t;
}

template <class I>
void IA_DDTemplate<I>::disassociate_template()
{
    if (this->bdtp->decr_ref() <= 0)
	delete this->bdtp;
    this->bdtp = 0;
}

template <class I>
IA_DDTemplate<I>::IA_DDTemplate(const IA_IntPointSet &ps, const I &i)
{
    set_and_reference_template(new IA_InvariantDT<I>(ps, i));
}

template <class I>
IA_DDTemplate<I>::IA_DDTemplate(const IA_IntPointSet &ps,
				I (*f)(const IA_IntPoint&))
{
    set_and_reference_template(new IA_FunctionDT<I>(ps, f));
}

template <class I>
IA_DDTemplate<I>::IA_DDTemplate(const IA_OtherDT<I> &o)
{
    set_and_reference_template(o.clone_self());
}

template <class I>
IA_DDTemplate<I>::~IA_DDTemplate()
{
    disassociate_template();
}
