// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	BaseDT.h,v $
// Revision 1.2  93/05/27  11:19:27  thoth
// Copyright Notices
// 
// Revision 1.1  93/04/17  18:59:02  thoth
// Initial revision
// 


#ifndef BaseDT_h_
#define BaseDT_h_

#include <iostream.h>
#include "ia.h"
#include "IntPoint.h"
#include "IntPointSet.h"
#include "ValueSet.h"

typedef const char* const IA_DiscreteImageType;

template <class I>
class IA_DDTemplate;

template <class I>
class IA_BaseDT {
protected:
    IA_IntPointSet ps;

    // refcount counts the number of references to this BaseDT object
    //   from DDTemplate container class objects.
    // It is maintained by container classes.
    int refcount;


public:
    // Constructor for BaseDT takes care of initting the refcount.
    // Derived classes need not frob it.
    // It is the responsibility of the container to maintain the refcount!

    IA_BaseDT(const IA_IntPointSet &p):ps(p) {
	refcount = 0;
    }

    virtual ~IA_BaseDT() {};

    int get_ref() { return refcount; }
    int incr_ref() { return ++refcount; }
    int decr_ref() { return --refcount; }

    // For the next function, we expect our container to trap
    // out-of-bounds points
    virtual I operator ()(const IA_IntPoint &) const =0;

    // Each class derived from BaseDT must support the member function
    // type which returns a DiscreteImageType value (a pointer to an int).
    // To distinguish between the different classes derived from BaseDT,
    // we make certain that type will be distinct for each of these classes
    // as follows:
    //	Each class derived from BaseDT defines a static function member dummy:
    //		static int dummy;
    //  The class definition for derived class "classname" must also be
    //	followed by a declaration of form
    //		template <class T> int classname<T>::dummy = 0;
    //	The member function type() in each class derived from BaseDT returns
    //	the address of dummy.
    // Thus each class returns a unique value for a call of type().

    virtual IA_DiscreteImageType type() const =0;
#if 0
    // NYI
    virtual IA_BaseDT *restricted_to(const IA_IntPointSet &ps) const =0;

    virtual IA_BaseDIVIter<I> *value_iter(const IA_DDTemplate<I> &) const;
    virtual IA_BaseDIPIter<I> *pixel_iter(const IA_DDTemplate<I> &) const;
#endif
    IA_IntPointSet domain() const { return this->ps; }

    virtual ostream& print_this(ostream&) const = 0;
    
    friend class IA_DDTemplate<I>;
};

#endif
