// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	BaseDIIter.h,v $
// Revision 1.6  93/05/27  11:19:26  thoth
// Copyright Notices
// 
// Revision 1.5  93/04/17  18:45:00  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.4  93/02/20  12:31:44  thoth
// There are now two sorts of BaseDIIters: value and pixel.  This
// makes the distinction in type between the DIVIter and DIPIter
// much clearer to the compiler and removes the need for some ugly
// code.
// 
// Revision 1.3  93/01/19  14:55:38  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/13  13:49:21  jnw
// initial revision
// 
// Revision 1.1  92/10/05  11:45:31  jnw
// Initial revision
// 

#ifndef BaseDIIter_h_
#define BaseDIIter_h_

#include "IntPoint.h"

template <class T> class IA_BaseDI;

template <class T>
class IA_BaseDIVIter {
protected:

    // This is the image over whose pixels we are iterating.
    IA_BaseDI<T> *domain;

public:

    IA_BaseDIVIter(const IA_BaseDI<T> *x);

    virtual ~IA_BaseDIVIter();

    // this returns a pointer to a copy of the object
    virtual IA_BaseDIVIter * clone_self() =0;

    // If the iterator has reached the end, the next() method will return 0.
    // Otherwise it will set the reference parameter to the
    // (lexicographically) next pixel in the image and return 1.

    virtual int next(T&) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return 0;
    }

    // this method resets the iterator to the beginning of the point set
    virtual void reset() = 0;

    IA_BaseDI<T> *domain_() const { return this->domain; }
};

template <class T>
class IA_BaseDIPIter {
protected:

    // This is the image over whose pixels we are iterating.
    IA_BaseDI<T> *domain;

public:

    IA_BaseDIPIter(const IA_BaseDI<T> *x);

    virtual ~IA_BaseDIPIter() {}

    // this returns a pointer to a copy of the object
    virtual IA_BaseDIPIter * clone_self() =0;

    // If the iterator has reached the end, the next() method will return 0.
    // Otherwise it will set the reference parameter to the
    // (lexicographically) next pixel in the image and return 1.

    virtual int next(IA_IntPoint&, T&) = 0;

    // this method resets the iterator to the beginning of the point set
    virtual void reset() = 0;

    IA_BaseDI<T> *domain_() const{ return this->domain; }
};

#endif
