//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log:	uchar-convolutions.desc,v $
// Revision 1.3  93/09/27  15:55:30  thoth
// Make the xxxmax_product and xxxmin_product functions a little more robust.
// 
// Revision 1.2  1993/09/21  11:45:04  thoth
// Give uchar convolutions the proper names.
//
// Revision 1.1  93/09/15  13:05:15  thoth
// Initial revision
// 
// Revision 1.2  93/05/27  11:41:16  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/18  11:26:37  thoth
// Initial revision
// 
// u_char linear_product u_char u_char zero=0
friend IA_UcharDiscreteImage linear_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_UcharDiscreteImage linear_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ) {
    return linear_product(img, templ, img.domain());
}

// we have to be careful doing the following transforms
// machine integers are NOT mathematical integers...
//the following is especially suspect.  What if there was NO
//intersection between the original image and the template.  We get the
//max value of the template, not the minimum value of the uchar ( 0 ).
//  *sigh*
// u_char addmax_product u_char u_char zero=0
friend IA_UcharDiscreteImage addmax_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_UcharDiscreteImage addmax_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ) {
    return addmax_product(img, templ, img.domain());
}

// u_char addmin_product u_char u_char  zero=255
friend IA_UcharDiscreteImage addmin_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_UcharDiscreteImage addmin_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ) {
    return addmin_product(img, templ, img.domain());
}

// take advantage of the fact that we are doing integer arithmetic and
// probably have extra precision lying around.  If the ints on your
// machine are not twice the size of chars (almost impossible) then use
// a long for the temp variable
// u_char multmax_product u_char u_char zero=0
friend IA_UcharDiscreteImage multmax_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_UcharDiscreteImage multmax_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ) {
    return multmax_product(img, templ, img.domain());
}

// what do we do when the template has a zero and the image is
// undefined?  Currently we multiply +infty (255) by zero and get 0, a
// minimum value.  crap.
// u_char multmin_product u_char u_char zero=255
friend IA_UcharDiscreteImage multmin_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_UcharDiscreteImage multmin_product(const IA_UcharDiscreteImage &img,
		const IA_UcharDDTemplate &templ) {
    return multmin_product(img, templ, img.domain());
}

