// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	OtherDT.h,v $
// Revision 1.1  93/09/15  12:55:38  thoth
// Initial revision
// 
// Revision 1.3  93/05/27  11:22:39  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:20:42  thoth
// Templates are now separate from images.
// 
// Revision 1.1  93/03/18  11:07:37  thoth
// Initial revision
// 

#ifndef OtherDT_h_
#define OtherDT_h_

#include "BaseDT.h"

template <class I>
class IA_OtherDT: public IA_BaseDT<I> {
  private:
    static char	dummy;
  public:
    IA_OtherDT(const IA_IntPointSet &ps)
    :IA_BaseDT<I>(ps) { }

    virtual IA_OtherDT<I> *clone_self() const =0;

    static IA_DiscreteImageType s_type() { return &dummy; }
    IA_DiscreteImageType type() const { return &dummy; }

    ostream &print_this(ostream &o) const { return o<<"User-defined template\n"; }

    // the user must provide
    // I operator()(const IA_IntPoint &p) const
    // IA_OtherDT<I> *clone_self() const;
};

// should go in OtherDT.c
template <class I>
char IA_OtherDT<I>::dummy;

#endif
