// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: image_errors.h,v $
// Revision 1.2  1994/01/31  15:58:06  thoth
// New error class for bad transposes.
//
// Revision 1.1  1993/12/29  15:44:32  thoth
// Initial revision
//

#ifndef image_errors_h_
#define image_errors_h_

struct Image_PointsetTooSmall_Exception : public GenericException {
  Image_PointsetTooSmall_Exception(const char *fn, int l)
    :GenericException
      ("Image: list of points is empty in dual vector constructor", fn, l) {}
};

struct Image_BadTranspose_Exception : public GenericException {
  Image_BadTranspose_Exception(const char *fn, int l)
    :GenericException
      ("Image: attempt to transpose a non-boxy or non-2-D image", fn, l) {}
};

#endif // image_errors_h_
