#!/local/bin/perl

#
#	Copyright 1993, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.
#

# $Id: generate-bo.perl,v 1.4 1994/01/07 15:15:14 thoth Exp $

#
# $Log: generate-bo.perl,v $
# Revision 1.4  1994/01/07  15:15:14  thoth
# Image class is now CoreImage and named image types are
# Image<P,T>.
#
# Revision 1.3  1993/12/29  17:33:18  thoth
# New operator scheme that prevents the need for trivial Image conversions.
#
# Revision 1.2  1993/11/17  18:39:50  thoth
# short-circuiting pointwise logical operations were failing to increment
# the pointer.  We now increment outside the expression.
# reductions are now static functions.
#
# Revision 1.1  1993/09/15  13:03:56  thoth
# Initial revision
#
# Revision 1.6  93/05/27  11:46:11  thoth
# Copyright Notices
# 
# Revision 1.5  93/04/08  13:22:35  thoth
# the domains of the two images are now checked for match.
# floats and u_chars are now passed by value.
# 
# Revision 1.4  93/03/10  13:47:07  thoth
# *** empty log message ***
# 

# This perl script generates meta files for binary image operations.
# The operations may be commutative (-c) or noncommutative (-nc).
# The operations may be Image - Image (-ii), Image - scalar (-is),
#	or scalar - Image (-si).
# Arguments are required.



# $Id: generate-bo.perl,v 1.4 1994/01/07 15:15:14 thoth Exp $

#
# $Log: generate-bo.perl,v $
# Revision 1.4  1994/01/07  15:15:14  thoth
# Image class is now CoreImage and named image types are
# Image<P,T>.
#
# Revision 1.3  1993/12/29  17:33:18  thoth
# New operator scheme that prevents the need for trivial Image conversions.
#
# Revision 1.2  1993/11/17  18:39:50  thoth
# short-circuiting pointwise logical operations were failing to increment
# the pointer.  We now increment outside the expression.
# reductions are now static functions.
#
# Revision 1.1  1993/09/15  13:03:56  thoth
# Initial revision
#
# Revision 1.6  93/05/27  11:46:11  thoth
# Copyright Notices
# 
# Revision 1.5  93/04/08  13:22:35  thoth
# the domains of the two images are now checked for match.
# floats and u_chars are now passed by value.
# 
# Revision 1.4  93/03/10  13:47:07  thoth
# *** empty log message ***
# 
# Revision 1.3  93/03/10  13:37:41  thoth
# A few extra parenthesis can't hurt.
# Detection of infix should now be automatic.
# 
# Revision 1.2  93/02/24  10:42:10  thoth
# revamping to allow strict relational operators.
# 




# variety is a number from 0..2 meaning
# VectorDI
# ConstDI
# other (but we can iterate over it!)

# Here is a vector with shorthand for each variety
@names = ("vec", "scalar", "iter");

# Given the variety of the image and its type:
# how will it be DECLARED as an argument to the static support procedure?
# $variety is 0..2.  $type may be either "LTYPE" or "RTYPE".
sub argtype {
	local($variety, $type) = @_;

	if ($variety == 0) {
		return "const IA_VectorI<IA_IntPoint, $type> *";
	} elsif ($variety == 1) {
		return "$type ";
	} else {
		return "IA_Image<IA_IntPoint, $type> ";
	}
}

# Given the variety of the image and its type:
# how will it be PASSED as an argument to the static support procedure?
# $variety is 0..2.  $side may be either "l" or "r".
sub I_argexpr {
	local($variety, $side) = @_;
	local($uside, $type);

	($uside = $side) =~ y/a-z/A-Z/;
	$type = $uside . "TYPE";
	if ($variety == 0) {
		return "(IA_VectorI<IA_IntPoint, $type> *)${side}hs.bip";
	} elsif ($variety == 1) {
		return "((IA_ConstI<IA_IntPoint, $type> *)${side}hs.bip)->value";
	} else {
		return "${side}hs";
	}
}

# When we're checking the type of an argument against the static types
# of all but the last variety, what is the class to check against?
# $variety is 0..1.  $type may be either "LTYPE" or "RTYPE".
sub arg_s_type {
	local($variety, $type) = @_;

	if ($variety == 0) {
		return "IA_VectorI<IA_IntPoint, $type>";
	} elsif ($variety == 1) {
		return "IA_ConstI<IA_IntPoint, $type>";
	} else {
		die "Class 2 is everything else.";
	}
}

# Emit variable declarations necessary for the central loop which
# actually calculates a result.  Vec needs a properly initialized
# pointer.  Const doesn't need an iterator.  Others just use a DIVIter
# of the appropriate type and a temporary of the appropriate type.
# $variety is 0..2.  $side may be either "l" or "r".
sub emititer {
	local($variety, $side) = @_;
	local($uside, $type);

	($uside = $side) =~ y/a-z/A-Z/;
	$type = $uside . "TYPE";
	if ($variety == 0) {
		print "\tconst ${type} *${side}s = ${side}hs->vec;\n";
	} elsif ($variety == 2) {
		print "\t${type} ${side}tmp;\n",
		    "\tIA_IVIter<IA_IntPoint, ${type}>\t${side}iter(${side}hs);\n";
	}
}

# When inside the loop and doing work, how do we use the iterator to
# calculate the result value?
# $variety is 0..2.  $side may be either "l" or "r".
sub inloop_val {
	($variety, $side) = @_;

	if ($variety == 0) {
		return "*${side}s";
	} elsif ($variety == 1) {
		return "${side}hs";
	} else {
		return "${side}tmp";
	}
}

# Emit the code for a support procedure.
# $i is the variety of the lhs image
# $j is the variety of the rhs image
sub generate_binary_op {
	local($i,$lside,$j,$rside) = @_;
	local($ltype, $rtype) = ($lside,$rside);
	local($sym);	
	$ltype =~ tr/a-z/A-Z/;
	$ltype .= "TYPE";
	$rtype =~ tr/a-z/A-Z/;
	$rtype .= "TYPE";

	if ($i==1 && $j==1) {
		print "// scalar-scalar operation is trivial\n\n";
		return;
	}

# Make sure that we don't duplicate the work of
# an image-scalar operation.
	if ($i==1 || $j==1) {
		$sym = $names[$i]."_".$names[$j]."_ATYPE_LTYPE_RTYPE_OPNAME";
		print "#ifndef ",$sym,"\n",
			"#define ",$sym,"\n";
	}

# function header and argument types
	if ($pwise) {
		print "static IA_Image<IA_IntPoint, ATYPE>\n";
	} else {
		print "static ATYPE ";
	}
	print $names[$i],"_",$names[$j],"_bo_OPNAME(";
	print &argtype($i,$ltype),"lhs,",&argtype($j,$rtype),"rhs)\n";
# the IntPointSet domain we are iterating over.
	print "{\n    const IA_IntPointSet domain = ";
	if ($i == 0) {
		print "lhs->";
	} elsif ($i == 2) {
		print "lhs.";
	} elsif ($j == 0) {
		print "rhs->";
	} elsif ($j == 2) {
		print "rhs.";
	}
	print "domain();\n";
# how long the result vector will be
	print "    const unsigned sz = domain.card();\n",
# declare the result vec
	"    ATYPE *const vec = new ATYPE[sz];\n\n    {\n",
# declare a scanning pointer for the inner loop
	"	ATYPE *ds = vec;\n";
# emit iterator declarations for the left and right hand sides of the operation
	&emititer($i,"l");
	&emititer($j,"r");
# begin the loop
	print "\tfor (unsigned i=0; i<sz; i++) {\n";
# do we need to get values from the IVIter?
	($i==2) && print "\t    liter(ltmp);\n";
	($j==2) && print "\t    riter(rtmp);\n";

# perform the operation for one pixel, Yaay!

	if ($pwise) {
		print "\t    *(ds++) = ";
	} else {
		# strictrel
		print "\t    if (!";
	}
	if ($infix) {
		print "( (", &inloop_val($i,"l"), ") SUBOP (",
			&inloop_val($j,"r"), ") )";
	} else {
		print "SUBOP(", &inloop_val($i,"l"), ", ",
			&inloop_val($j,"r"), ")";
	}
	if ($pwise) {
		print ";\n";
	} else {
		print ")\n\t\treturn 0;\n";
	}
	($i==0) && print "\t    ls++;\n";
	($j==0) && print "\t    rs++;\n";
	print "\t}\n";
	print "    }\n";
	if ($pwise) {
# loop finished.  Result vector is filled.  Give the value vec away.
		print "    return IA_Image<IA_IntPoint, ATYPE>(domain, vec, sz, 1);\n";
	} else {
		print "    return 1;\n";
	}
	print "}\n";
	if ($i==1 || $j==1) {
		print "#endif // $sym\n";
	}
	print "\n";
}

# Emit code for the beginning of an image variety case
# $variety is 0..2.  $side is "l" or "r".
sub emit_begin_imagecase {
	local($variety,$side) = @_;
	local($uside, $type);

	($uside = $side) =~ y/a-z/A-Z/;
	$type = $uside . "TYPE";

	if ($variety+1 < @names) {
		print "if (${side}hs.type() == ", &arg_s_type($variety,$type), "::s_type()) ";
	}
	print "{\n";
}

# Emit the call to a support procedure for a particular variety combination.
# This is where the ConstDI - ConstDI case is optimized.
# $i and $j are the varieties of the left- and right-hand side image arguments.
# If one of the varieties is negative, that means the corresponding
# argument to the enclosing procedure was a scalar argument instead of
# an image argument.
sub emit_support_call {
    local($i,$j) = @_;
    local($lexpr,$rexpr);
    $domain = "lhs.domain()";
    if ($i<0) {
	$i=1;
	$lexpr = "lhs";
	$domain = "rhs.domain()";
    } else {
        $lexpr = &I_argexpr($i,"l");
    }
    if ($j<0) {
	$j=1;
	$rexpr = "rhs";
    } else {
	$rexpr = &I_argexpr($j,"r");
    }
    if ($i==1 && $j==1) {
	$pwise && print "IA_Image<IA_IntPoint, ATYPE> ($domain, ";
	if ($infix) {
		print "($lexpr) SUBOP ($rexpr)";
	} else {
		print "SUBOP($lexpr, $rexpr)";
	}
	$pwise && print ")";
    } elsif ($comm && $j < $i) {
	print $names[$j],"_",$names[$i],"_bo_OPNAME(",
		$rexpr,",",$lexpr,")";
    } else {
	print $names[$i],"_",$names[$j],"_bo_OPNAME(",
		$lexpr,",",$rexpr,")";
    }
}

# Emit code for the end of an image variety case.
sub emit_end_imagecase {
	local($variety,$indent) = @_;
	print $indent,"}";
	if ($variety+1 < @names) {
		print " else ";
	}
}

#
# begin the main code
#


# parse arguments
$comm = 2;
$arity = 3;
$optype = 2;
$pwise = 2;
while (@ARGV) {
	$_ = shift(@ARGV);
	if ($_ eq "-nc") {
		$comm = 0;
	} elsif ($_ eq "-c") {
		$comm = 1;

	} elsif ($_ eq "-II") {
		$arity = 0;
	} elsif ($_ eq "-Is") {
		$arity = 1;
	} elsif ($_ eq "-sI") {
		$arity = 2;

	} elsif ($_ eq "-fn") {
		$optype = 0;
	} elsif ($_ eq "-op") {
		$optype = 1;
#	} elsif ($_ eq "-sr") {
#		$optype = 2;

	} elsif ($_ eq "-sr") {
		$pwise = 0;
	} elsif ($_ eq "-pw") {
		$pwise = 1;
	} else {
		die "unrecognized flag: $_\n";
	}
}
die "No value selected for commutativity.  Choose -c or -nc\n" if ($comm>1);
die "Must select -II, -Is, or -sI.\n" if ($arity>2);
die "Must select -op or -fn.\n" if ($optype>1);
die "Must select -sr or -pw.\n" if ($pwise>1);

#

$infix = ($optype==1);

# emit the code for support procedures

if ($arity == 0) {
# emit support procedures for an image-image operation
	for ($i=0; $i<@names; $i++) {
	  for ($j=($comm?$i:0); $j<@names; $j++) {
		# If the operation is commutative, we don't need to generate
		# the mirror image of an asymmetric support procedure.
		# We merely have to swap the order of the arguments in
		# the call.
		&generate_binary_op($i,"l",$j,"r");
	  }
	}
} elsif ($arity == 1) {
# emit support procedures for an image-scalar operation
	for ($i=0; $i<@names; $i++) {
		if ($i>1 && $comm) {
			&generate_binary_op(1,"r",$i,"l");
		} else {
			&generate_binary_op($i,"l",1,"r");
		}
	}
} else {
# emit support procedures for an scalar-image operation
	for ($i=0; $i<@names; $i++) {
		if ($i<1 && $comm) {
			&generate_binary_op($i,"r",1,"l");
		} else {
			&generate_binary_op(1,"l",$i,"r");
		}
	}
}

# Emit the code that calls the support procedures.
# This is an externally available operator.

if (0 && $infix) {
	$funcname = "operator OP";
} else {
	$funcname = "OP";
}

if ($pwise) {
	print "IA_Image<IA_IntPoint, ATYPE>\n";
} else {
	print "ATYPE ";
}

if ($arity==0) {

	# generate an image - image operation

	print "$funcname ( const IA_CoreImage<IA_IntPoint, LTYPE> &lhs_,\n",
		"\t      const IA_CoreImage<IA_IntPoint, RTYPE> &rhs_)\n{\n",
		"    if (lhs_.domain() != rhs_.domain()) {\n",
		"\tstatic ",
		$pwise?"IA_Image<IA_IntPoint, ATYPE>":"ATYPE", "\trval;\n",
		"\tia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);\n",
		"\treturn rval;\n",
		"    }\n\n";
	print "    IA_Image<IA_IntPoint, LTYPE>	lhs(lhs_);\n";
	print "    IA_Image<IA_IntPoint, RTYPE>	rhs(rhs_);\n";

	print "    ";
	for ($i=0; $i<@names; $i++) {
	  &emit_begin_imagecase($i,"l");

	  print "\t";
	  for ($j=0; $j<@names; $j++) {
	    &emit_begin_imagecase($j,"r");
	    print "\t    return ";
	    &emit_support_call($i,$j);
	    print ";\n";
	    &emit_end_imagecase($j,"\t");
	  }
	  &emit_end_imagecase($i,"\n    ");
	}
	print "\n}\n";

} elsif ($arity == 1) {

	# generate an image - scalar operation

	print "$funcname ( const IA_CoreImage<IA_IntPoint, LTYPE> &lhs_, RTYPE rhs)\n{\n";
	print "    IA_Image<IA_IntPoint, LTYPE>	lhs(lhs_);\n";
	print "    ";
	for ($i=0; $i<@names; $i++) {
	  &emit_begin_imagecase($i,"l");
	  print "\treturn ";
	  &emit_support_call($i,-1);
	  &emit_end_imagecase($i,";\n    ");
	}
	print "\n}\n";

} else {

	# generate an image - scalar operation

	print "$funcname (LTYPE lhs, const IA_CoreImage<IA_IntPoint, RTYPE> &rhs_)\n{\n";
	print "    IA_Image<IA_IntPoint, RTYPE>	rhs(rhs_);\n";
	print "    ";
	for ($j=0; $j<@names; $j++) {
	  &emit_begin_imagecase($j,"r");
	  print "\treturn ";
	  &emit_support_call(-1,$j);
	  &emit_end_imagecase($j,";\n    ");
	}
	print "\n}\n";

}
