// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char VectorIVIterrcsid[] = "$Id: VectorImageIter.c,v 1.1 1993/09/15 12:57:52 thoth Exp $";

//
// $Log: VectorImageIter.c,v $
// Revision 1.1  1993/09/15  12:57:52  thoth
// Initial revision
//

#include "VectorImageIter.h"

template < class P,class T>
IA_VectorIVIter<P,T>::IA_VectorIVIter(const IA_VectorI<P,T> *img)
: IA_BaseIVIter<P,T>(img)
{
    this->num_left = this->domain->domain().card();
    this->index = 0;
}

template < class P,class T>
IA_VectorIVIter<P,T>::IA_VectorIVIter(const IA_VectorIVIter<P,T> &iter)
: IA_BaseIVIter<P,T>(iter.domain)
{
    this->num_left = iter.num_left;
    this->index = iter.index;
}

template < class P,class T>
int IA_VectorIVIter<P,T>::next(T& pixel_value)
{
    if (this->num_left > 0) {
	pixel_value = this->vip()->vec[this->index++];
	this->num_left--;
	return 1;
    } else {
	return 0;
    }
}

//
//


template < class P,class T>
IA_VectorIPIter<P,T>::IA_VectorIPIter(const IA_VectorI<P,T> *img)
: IA_BaseIPIter<P,T>(img), psiter(img->domain())
{
    index = 0;
}

template < class P,class T>
IA_VectorIPIter<P,T>::IA_VectorIPIter(const IA_VectorIPIter<P,T> &iter)
: IA_BaseIPIter<P,T>(iter.domain), psiter(iter.psiter)
{
    this->index = iter.index;
}

template < class P,class T>
int IA_VectorIPIter<P,T>::next(P& pixel_location, T& pixel_value)
{
    if (!psiter(pixel_location))
	return 0;
    pixel_value = vip()->vec[index++];
    return 1;
}




