// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char IntDI_rcsid[] = "$Id: IntDI.c,v 1.6 1994/01/31 15:46:30 thoth Exp $";

//
// $Log: IntDI.c,v $
// Revision 1.6  1994/01/31  15:46:30  thoth
// read_PGM now can return the maxval.
// pseudo_division is now available.
//
// Revision 1.5  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.4  1993/12/29  17:03:42  thoth
// write_PGM functions will no longer calculate a maxval of 0.
//
// Revision 1.3  1993/11/17  18:23:26  thoth
// IPSIter is now PSIter<IntPoint>.
// restriction functions now go in the individual image implementation modules.
// read_PGM and write_PGM now support P2 ASCII images.
//
// Revision 1.2  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.1  1993/09/15  12:54:51  thoth
// Initial revision
//
// Revision 1.9  93/05/27  11:36:28  thoth
// Copyright Notices
// 
// Revision 1.8  93/05/26  17:02:11  thoth
// instantiate IAAIO.
// 
// Revision 1.7  93/05/18  21:40:49  thoth
// *** empty log message ***
// 
// Revision 1.6  93/04/29  11:20:40  thoth
// non-boxy images now output correctly.
// 
// Revision 1.5  93/04/17  18:48:02  thoth
// use IA_IntPoint instead of IntPoint
// 
// Revision 1.4  93/04/08  13:15:13  thoth
// write_PGM will now compute maxval if not supplied.
// read/write_PGM now accept character strings as well
// as ostream&s and treat them as filenames.
// const_reduce special cases now available.
// 
// Revision 1.3  93/03/10  13:35:32  thoth
// intimage-intimage operations are now generated by a perl script.
// We must still provide some inline functions to help it out though.
// 
// Revision 1.2  93/02/23  14:25:12  thoth
// force an instantiation of OtherDI.
// FunctionRefDIs are supported again.
// 
// Revision 1.1  93/02/20  12:17:42  thoth
// Initial revision
// 
// 

#include	"Closure.h"
#include	"PSIter.h"

#include	"IntDI.h"
#include	"VectorI.h"
#include	"ConstI.h"
#include	"ClosureI.h"
#include	"ErrorI.h"
#include	"ImageIter.h"

#include	<math.h>
#include	<fstream.h>
#include	<values.h>

#include	"Bit.h"

//
//
//

#include "restrict.h"

IA_BaseImage<IA_Point<int>,int> *restrict_toD(const IA_BaseImage<IA_Point<int>, int> *im, const IA_Set<IA_Point<int> > &ips) {
    return restrictD_toD(im, ips);
}

IA_BaseImage<IA_Point<int>,int> *restrict_toD(const IA_BaseImage<IA_Point<double>, int> *im, const IA_Set<IA_Point<int> > &ips) {
    return restrictC_toD(im, ips);
}

//
//

istream &wsc(istream &);	// from UcharDI.c

IA_Image<IA_IntPoint,int>
IA_Image<IA_IntPoint,int>::read_PGM(istream &istr, int *maxval_ret)
{
    int	width, height,maxval;
    int	code;
    if (istr.get()=='P' && ((code=istr.get())=='5' || code == '2')
	&& istr>>wsc>>width>>wsc>>height>>wsc>>maxval) {
	if (maxval_ret)
	    *maxval_ret = maxval;
	{
	    int	ch = istr.get();
	    if (ch!='\n')
		istr.putback(ch);
	}
	const unsigned	size=width*height;
	int	*data = new int[size];
	if (code=='5') {
	    unsigned char	*tmp = new unsigned char[size];
	    if (!istr.read(tmp, size)) {
		delete[] data;
		ia_throw(IA::PNM_IO_ERROR, __FILE__, __LINE__);
		return IA_Image<IA_IntPoint,int>();
	    }
	    for (unsigned i=0; i<size; i++)
		data[i] = tmp[i];
	    delete[] tmp;
	} else {
	    for (unsigned i=0; i<size; i++) {
		if (!(istr >> data[i])) {
		    delete[] data;
		    ia_throw(IA::PNM_IO_ERROR, __FILE__, __LINE__);
		    return IA_Image<IA_IntPoint,int>();
		}
	    }
	}
	return IA_Image<IA_IntPoint,int>
	    (IA_IntPointSet(IA_IntPoint(0,0), IA_IntPoint(height-1,width-1)),
	     data, size, 1);
    } else {
	ia_throw(IA::PNM_IO_ERROR, __FILE__, __LINE__);
	return IA_Image<IA_IntPoint,int>();
    }
}

IA_Image<IA_IntPoint,int>
IA_Image<IA_IntPoint,int>::read_PGM(const char *fname, int *maxval)
{
    ifstream	in(fname);
    return read_PGM(in, maxval);
}

ostream &IA_Image<IA_IntPoint,int>::write_PGM(ostream &o, unsigned maxval) const
{
    // what if image is not dimension 2?

    IA_IntPointSet boxydomain(domain().inf(),domain().sup());
    IA_IntPoint	width(domain().sup()-domain().inf()+1);
    const int	binary_pgm = (maxval <= 255);
    if (binary_pgm)
	o<<"P5\n";
    else
	o<<"P2\n";
    o<<width[1] << " " << width[0] << " " << maxval << "\n";
    IA_PSIter<IA_IntPoint>	iter(boxydomain);
    IA_IntPoint	ip;

    int	idx=0;
    int	oldwidth = o.width(7);
    while (iter(ip)) {
	if (binary_pgm) {
	    o.put((char) ( domain().contains(ip)?(*this)(ip):0));
	} else {
	    o << ( domain().contains(ip)?(*this)(ip):0);
	    if (idx%10 == 0)
		o << '\n';
	    else
		o << ' ';
	}
	idx++;
    }
    return o;
}

ostream &IA_Image<IA_IntPoint,int>::write_PGM(ostream &o) const
{
    const unsigned	m = max(*this);
    return write_PGM(o,m>0?m:1);
}

void IA_Image<IA_IntPoint,int>::write_PGM(const char *fname, unsigned maxval) const
{
    ofstream	out(fname);
    write_PGM(out, maxval);
}

void IA_Image<IA_IntPoint,int>::write_PGM(const char *fname) const
{
    ofstream	out(fname);
    const unsigned	m = max(*this);
    write_PGM(out, m>0?m:1);
}

//
// below are included the implementations of every image-image
// and image-scalar operation we could think of for integer images.
//

template <class T>
inline T max(T a, T b)
{
    return (a<b)?b:a;
}

template <class T>
inline T min(T a, T b)
{
    return (a<b)?a:b;
}

inline int isqrt(int v)
{
    return (int) (sqrt((double) v));
}

template <class T>
inline T sqr(T v)
{
    return v*v;
}

inline int pseudo_div(int a, int b)
{
    return (b==0) ? 0 : (a/b);
}


#define  const_reduce_int_int_reduce_plus
inline int const_reduce_reduce_plus(unsigned sz, int arg)
{
    return sz * arg;
}

#define const_reduce_int_int_max
inline int const_reduce_max(unsigned, int arg)
{
    return arg;
}

#define const_reduce_int_int_min
inline int const_reduce_min(unsigned, int arg)
{
    return arg;
}

#include "IntImageOps.c"

//
//
//

#if 0

class blah : public IA_ClosureI<IA_IntPoint, int> {
  public:
    blah() 
    :IA_ClosureI<IA_IntPoint,int>(IA_IntPointSet()) {}
    ostream &print_this(ostream &o) const { return o;}
    int operator()(const IA_IntPoint &) const { return 0; }
    IA_ClosureI<IA_IntPoint,int>* clone_self() const { return 0; }
};

static void dummy001()
{
    IA_IntPoint		ip;
    IA_IntPointSet	ps;
    IA_Image<IA_IntPoint,int>	i1;
    IA_Image<IA_IntPoint,int>
	i2(i1),
	i3(ps,0),
	i4(ps, (int*)0, 0, 1),
	i5(ps, (int*)0, 0),
	i6(blah()),
	i7(ps, (int(*)(const IA_IntPoint&))0),
	i10(IA_CoreImage<IA_IntPoint,int>());
    int	sc;

    i1 = i1.restrict(i2.range());
    i1 = i1.xlated(ip);
    (IA_CoreImage<IA_IntPoint,int>&)i1 = 2;
    (void)i1.type();
    i1[ip] = i1(ip);
    i1 = i1.restrict(i2.domain());
    (void)i1.extend(i2);
    (void)i1.reduce((int (*)(const int&,const int&)) 0, 0);
    (void)i1.reduce((int (*)( int, int)) 0, 0);
    cout << (IA_CoreImage<IA_IntPoint,int>&)i1;

#if 0
    IA_Image<IA_IntPoint,int>::read_IAA("");
    IA_Image<IA_IntPoint,int>::read_IAA("","");

    i1.write_IAA("");
    i1.write_IAA("","");
#endif

    IA_IVIter<IA_IntPoint, int>	iter1(i1), iter2;
    IA_IPIter<IA_IntPoint, int>	iter3(i2), iter4;
    iter1 = iter2;
    iter3 = iter4;
#if 1
    iter1.reset();
    iter1(sc);
    iter3.reset();
    iter3(ip, sc);
#endif
#if 0
    compose(i1, (IA_IntPoint(*)(const IA_IntPoint&))0);
    compose(i1, *(IA_Closure<IA_IntPoint, IA_IntPoint>*)0);
    compose((int(*)(int))0, i1);
    compose((u_char(*)(int))0, i1, (u_char*)0);
#endif

    IA_ValueSet<int>	vs(i1.range());
    // I shouldn\'t have to do the following two lines
    // vs.value_type_compare(0,0);
}
#endif
