// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ComplexDDTempl.h,v $
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
// 

#ifndef ComplexDDTempl_h_
#define ComplexDDTempl_h_

#include "DDTempl.h"
#include "ComplexDI.h"

class IA_ComplexDDTemplate: public IA_DDTemplate<IA_Image<IA_IntPoint,complex> > {
  public:

    IA_ComplexDDTemplate(unsigned dim, const IA_Image<IA_IntPoint,complex> im)
    :IA_DDTemplate<IA_Image<IA_IntPoint,complex> >(IA_WhiteHole(dim), im) { }

    IA_ComplexDDTemplate(const IA_ClosureDT< IA_Image<IA_IntPoint,complex> > &o)
    :IA_DDTemplate<IA_Image<IA_IntPoint,complex> >(o) { }

    IA_ComplexDDTemplate(unsigned dim,
		       IA_Image<IA_IntPoint,complex> (*f)(const IA_IntPoint&))
    :IA_DDTemplate<IA_Image<IA_IntPoint,complex> >(IA_WhiteHole(dim), f) { }
#include	"ComplexConvolutions.h"
};

#endif
