// Emacs: -*- C++ -*-

//
//      Copyright 1993, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//


//
// $Log: BitDDTempl.h,v $
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
// 

#ifndef BitDDTempl_h_
#define BitDDTempl_h_

#include "DDTempl.h"
#include "BitDI.h"

class IA_BitDDTemplate: public IA_DDTemplate<IA_Image<IA_IntPoint,IA_Bit> > {
  public:
    IA_BitDDTemplate(unsigned dim, const IA_Image<IA_IntPoint,IA_Bit>  im)
    :IA_DDTemplate<IA_Image<IA_IntPoint,IA_Bit> >(IA_WhiteHole(dim), im) { }
//    IA_BitDDTemplate(const IA_IntPointSet &ps, const IA_Image<IA_IntPoint,IA_Bit>  im)
//    :IA_DDTemplate<IA_Image<IA_IntPoint,IA_Bit> >(ps, im) { }

    IA_BitDDTemplate(const IA_ClosureDT< IA_Image<IA_IntPoint,IA_Bit>  > &o)
    :IA_DDTemplate<IA_Image<IA_IntPoint,IA_Bit> >(o) { }

//    IA_BitDDTemplate(const IA_IntPointSet &ps,
//                   IA_Image<IA_IntPoint,IA_Bit>  (*f)(const IA_IntPoint&))
//    :IA_DDTemplate<IA_Image<IA_IntPoint,IA_Bit> >(ps, f) { }
    IA_BitDDTemplate(unsigned dim,
		     IA_Image<IA_IntPoint,IA_Bit>  (*f)(const IA_IntPoint&))
    :IA_DDTemplate<IA_Image<IA_IntPoint,IA_Bit> >(IA_WhiteHole(dim), f) { }

#include        "BitConvolutions.h"
};

#endif
