// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: AuxImage.h,v $
// Revision 1.2  1994/02/01  17:01:37  thoth
// Fix some screwy instantiation problems.
//
// Revision 1.1  1994/01/31  16:43:38  thoth
// Initial revision
//

#ifndef AuxImage_h_
#define AuxImage_h_

#include "Closure.h"
#include "Bit.h"
#include "Point.h"
#include "ValueSet.h"
#include "Set.h"

template <class P, class T> class IA_CoreImage;
template <class P,class T> class IA_VectorI;

template <class T> IA_CoreImage<IA_IntPoint,IA_Bit>
chi_contains(const IA_CoreImage<IA_IntPoint, T> &lhs,
	     const IA_ValueSet<T> &rhs);

// the following two functions should not have to be declared here but
// CFront is busted
template <class T> IA_CoreImage<IA_IntPoint, int>
iter_chi_contains(const IA_CoreImage<IA_IntPoint, T> &lhs,
		  const IA_ValueSet<T> &rhs);
template <class T> IA_CoreImage<IA_IntPoint, int>
vec_chi_contains(const IA_VectorI<IA_IntPoint, T> *lhs,
		 const IA_ValueSet<T> &rhs)

//
//

template <class T> IA_CoreImage<IA_IntPoint,T>
transpose(const IA_CoreImage<IA_IntPoint, T> &);

// the following two functions should not have to be declared here but
// CFront is busted
template <class T> IA_CoreImage<IA_IntPoint, T>
vec_transpose(const IA_VectorI<IA_IntPoint, T> *img);

template <class T> IA_CoreImage<IA_IntPoint, T>
iter_transpose(const IA_CoreImage<IA_IntPoint, T> &img);

//
//

// spatial composition
template <class P, class T>
IA_CoreImage<P,T> compose
(const IA_CoreImage<P,T>&,
 const IA_Closure<P, P> &);

template <class P, class T>
IA_CoreImage<P,T> compose(const IA_CoreImage<P,T>&,
			    P (*)(const P&));

// value composition
template <class P, class Q, class R, class S, class T>
IA_CoreImage<P,Q> compose(R (*)(S), const IA_CoreImage<P,T> &, const Q*, const R*, const S*);

template <class P, class R, class S, class T>
inline IA_CoreImage<P,R> compose(R (*f)(S), const IA_CoreImage<P,T> &i, const R*, const S*) { return compose(f, i, (const R*)0, (const R*)0, (const S*)0); }

template <class P, class S, class T>
inline IA_CoreImage<P,S> compose(S (*f)(T), const IA_CoreImage<P,T> &i, const S*) { return compose(f, i, (const S*)0, (const S*)0, (const T*)0); }

template <class P, class T>
inline IA_CoreImage<P,T> compose(T (*f)(T), const IA_CoreImage<P,T> &i) { return compose(f, i, (const T*)0, (const T*)0, (const T*)0); }



#include "Closure.h"

template <class P, class Q, class R, class S, class T>
IA_CoreImage<P,Q> compose(const IA_Closure<S,R>&, const IA_CoreImage<P,T> &, const Q*);

template <class P, class R, class S, class T>
inline IA_CoreImage<P,R> compose(const IA_Closure<S,R>&f, const IA_CoreImage<P,T> &i) { return compose(f, i, (const R*)0); }

#endif // AuxImage_h_
