// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: Pixel.h,v $
// Revision 1.1  1993/12/29  15:44:32  thoth
// Initial revision
//

#ifndef Pixel_h_
#define Pixel_h_

#include "Point.h"

template <class P, class T>
class IA_Pixel {
public:				// why not?
    P	point;
    T	value;
public:
    IA_Pixel() { }
    IA_Pixel(const P &p, T v) : point(p), value(v) { }
#if 1 // Maybe this will fix CFront
    IA_Pixel& operator=(const IA_Pixel &p) {
	point = p.point;
	value = p.value;
	return *this;
    }
#endif
    static int compare(const IA_Pixel &lhs, const IA_Pixel &rhs) {
	return pointcmp(lhs.point, rhs.point);
    }
    static int vcompare(const void *a, const void *b) {
	return compare (*(const IA_Pixel<P,T>*)a, *(const IA_Pixel<P,T>*)b);
    }
};

#endif
