// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: IntDI.h,v $
// Revision 1.9  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.8  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.7  1994/03/30  13:51:17  thoth
// inline non-member functions to do image input.
//
// Revision 1.6  1994/01/31  15:48:12  thoth
// read_PGM now can return the maxval.
//
// Revision 1.5  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.4  1993/12/29  17:04:57  thoth
// pointarray valuearray constructor.
//
// Revision 1.3  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.2  1993/09/27  15:51:50  thoth
// op= with a constant now works.
//
// Revision 1.1  93/09/15  12:55:01  thoth
// Initial revision
// 
// Revision 1.7  93/06/10  17:24:22  thoth
// 
// 
// Revision 1.6  93/05/27  11:22:24  thoth
// Copyright Notices
// 
// Revision 1.5  93/05/26  17:02:27  thoth
// write_PGM convenience friends.
// 
// Revision 1.4  93/04/08  13:17:02  thoth
// write_PGM will now compute maxval if not supplied.
// read/write_PGM now accept character strings as well
// as ostream&s and treat them as filenames.
// 
// Revision 1.3  93/03/10  13:36:18  thoth
// Provide some simple inline definitions that we don't use perl for.
// 
// Revision 1.2  93/02/23  14:31:04  thoth
// FunctionRefDIs are supported again.
// OtherDIs are supported.
// We have a clue for operator<<.
// operations +-*/ are supported for image-image.
// 
// Revision 1.1  93/02/20  12:18:44  thoth
// Initial revision
// 
// 

#ifndef IntDI_h_
#define IntDI_h_

#include <sys/types.h>
#include "IntPoint.h"
#include "CoreImage.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

#include	<complex.h>	// for the complex conversion
#include "Bit.h"		// for the to_bit converter function

class IA_Image<IA_Point<int>,int>: public IA_CoreImage<IA_Point<int>,int>
{
  public:
    IA_Image():IA_CoreImage<IA_Point<int>,int>() {}

    IA_Image(const IA_Image<IA_Point<int>,int>& im)
    :IA_CoreImage<IA_Point<int>,int>(im) {}

    IA_Image(IA_Set<IA_Point<int> > ps, int value)
    :IA_CoreImage<IA_Point<int>,int>(ps,value) {}

    IA_Image(IA_Set<IA_Point<int> > ps, int *vp, unsigned sz,
			int giveaway=0)
    :IA_CoreImage<IA_Point<int>,int>(ps, vp, sz, giveaway) {}

    IA_Image(IA_Set<IA_Point<int> > ps, const int *vp, unsigned sz)
    :IA_CoreImage<IA_Point<int>,int>(ps, vp, sz) {}

    IA_Image(const IA_Point<int> *pp, unsigned plen, int *vp, unsigned vlen, int giveaway=0)
    :IA_CoreImage<IA_Point<int>,int>(pp, plen, vp, vlen, giveaway) {}
    IA_Image(const IA_Point<int> *pp, unsigned plen, const int *vp, unsigned vlen)
    :IA_CoreImage<IA_Point<int>,int>(pp, plen, vp, vlen) {}

    IA_Image(const IA_ClosureI<IA_Point<int>,int> &img)
    :IA_CoreImage<IA_Point<int>,int>(img) {}

    IA_Image(IA_Set<IA_Point<int> > ps, int (*f)(const IA_Point<int>&))
    :IA_CoreImage<IA_Point<int>,int>(ps,f) {}

    IA_Image( const IA_CoreImage<IA_Point<int>,int> &d)
    :IA_CoreImage<IA_Point<int>,int>(d) {}

    virtual ~IA_Image(){ }

    IA_Image& operator=(int v) {
	(IA_CoreImage<IA_Point<int>,int>&)*this = v;
	return *this;
    }
#include	"IntIOps.h"

    static IA_Image read_PGM(istream &, int *maxval=0);
    static IA_Image read_PGM(const char *fname, int *maxval=0);

    ostream& write_PGM(ostream &, unsigned) const;
    ostream& write_PGM(ostream &) const;
    void write_PGM(const char *fname, unsigned) const;
    void write_PGM(const char *fname) const;
};

inline int operator!=(const IA_CoreImage<IA_Point<int>,int> &lhs,
	       const IA_CoreImage<IA_Point<int>,int> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_CoreImage<IA_Point<int>,int> &lhs, int rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(int lhs, const IA_CoreImage<IA_Point<int>,int> &rhs) {
    return ! (rhs == lhs);
}

//
//

inline IA_Image<IA_Point<int>,int> read_int_PGM(istream &i, int *maxval=0) {
    return IA_Image<IA_Point<int>,int>::read_PGM(i, maxval);
}
inline IA_Image<IA_Point<int>,int> read_int_PGM(const char *fname,
					      int *maxval=0) {
    return IA_Image<IA_Point<int>,int>::read_PGM(fname, maxval);
}

//
//

inline ostream& write_PGM(const IA_CoreImage<IA_Point<int>,int> &im, ostream &o, unsigned max) {
    return IA_Image<IA_Point<int>,int>(im).write_PGM(o, max);
}

inline ostream& write_PGM(const IA_CoreImage<IA_Point<int>,int> &im, ostream &o) {
    return IA_Image<IA_Point<int>,int>(im).write_PGM(o);
}

inline void write_PGM(const IA_CoreImage<IA_Point<int>,int> &im, const char *fname) {
    IA_Image<IA_Point<int>,int>(im).write_PGM(fname);
}

inline void write_PGM(const IA_CoreImage<IA_Point<int>,int> &im,
		      const char *fname, unsigned max) {
    IA_Image<IA_Point<int>,int>(im).write_PGM(fname, max);
}

//
//

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_CoreImage<IA_Point<int>,int>&);


#endif
