// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FloatDI.h,v $
// Revision 1.7  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/01/31  15:45:38  thoth
// Image<IntPoint,float> can now be converted to CoreImage<IntPoint,complex>
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.2  1993/09/27  15:49:59  thoth
// op= with a constant now works.
//
// Revision 1.1  93/09/15  12:52:40  thoth
// Initial revision
// 
// Revision 1.4  93/05/27  11:21:48  thoth
// Copyright Notices
// 
// Revision 1.3  93/05/26  17:00:47  thoth
// Provide some compositions that will be frequently used.
// 
// Revision 1.2  93/04/29  11:19:48  thoth
// Workaround for CFront implementation ugliness.
// 
// Revision 1.1  93/04/17  18:59:25  thoth
// Initial revision
// 


#ifndef FloatDI_h_
#define FloatDI_h_

#include "CoreImage.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE
#include "IntDI.h"		// for chi relations

#include	<complex.h>	// for the complex conversion

class IA_Image<IA_Point<int>,float>: public IA_CoreImage<IA_Point<int>,float>
{
  public:
    IA_Image():IA_CoreImage<IA_Point<int>,float>() {}

    IA_Image(const IA_Image& im)
    :IA_CoreImage<IA_Point<int>,float>(im) {}
    IA_Image(IA_Set<IA_Point<int> > ps, float value)
    :IA_CoreImage<IA_Point<int>,float>(ps,(float)value) {}
    IA_Image(IA_Set<IA_Point<int> > ps, float *vp, unsigned sz,
			  int giveaway=0)
    :IA_CoreImage<IA_Point<int>,float>(ps, vp, sz, giveaway) {}

    IA_Image(const IA_ClosureI<IA_Point<int>,float> &img)
    :IA_CoreImage<IA_Point<int>,float>(img) {}

    IA_Image(IA_Set<IA_Point<int> > ps, float (*f)(const IA_Point<int>&))
    :IA_CoreImage<IA_Point<int>,float>(ps,f) {}

    IA_Image( const IA_CoreImage<IA_Point<int>,float> &d)
    :IA_CoreImage<IA_Point<int>,float>(d) {}

    virtual ~IA_Image(){ }

    IA_Image& operator=(float v) {
	float	temp=v;		// workaround CFront problem
	(IA_CoreImage<IA_Point<int>,float>&)*this = temp;
	return *this;
    }
#include	"FloatIOps.h"
#if 0
    static IA_Image read_PGM(istream &);
    static IA_Image read_PGM(const char *fname);

    ostream& write_PGM(ostream &, unsigned) const;
    ostream& write_PGM(ostream &) const;
    void write_PGM(const char *fname, unsigned) const;
    void write_PGM(const char *fname) const;
#endif
};

inline int operator!=(const IA_CoreImage<IA_Point<int>,float> &lhs,
	       const IA_CoreImage<IA_Point<int>,float> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_CoreImage<IA_Point<int>,float> &lhs, float rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(float lhs, const IA_CoreImage<IA_Point<int>,float> &rhs) {
    return ! (rhs == lhs);
}

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_CoreImage<IA_Point<int>,float>&);

inline IA_Image<IA_Point<int>,float> compose
	(double (*f)(double), const IA_CoreImage<IA_Point<int>,float>& fi)
{
    return compose(f, fi, (float*)0, (double*)0, (double*)0);
}

inline IA_Image<IA_Point<int>,float> compose
	(double (*f)(double), const IA_Image<IA_Point<int>,float>& fi)
{
    return compose(f, (IA_CoreImage<IA_Point<int>,float>&)fi,
		   (float*)0, (double*)0, (double*)0);
}

#endif
