// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: CplxDI.h,v $
// Revision 1.5  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.4  1994/07/25  17:24:13  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  16:53:35  thoth
// removed PGM cruft.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
// 


#ifndef ComplexDI_h_
#define ComplexDI_h_
#include <complex.h>
#include "CoreImage.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE
#include "IntDI.h"		// for chi relations

class IA_Image<IA_Point<int>,complex>: public IA_CoreImage<IA_Point<int>, complex>
{
  public:
    IA_Image():IA_CoreImage<IA_Point<int>, complex>() {}

    IA_Image(const IA_CoreImage<IA_Point<int>, float> &real,
                            const IA_CoreImage<IA_Point<int>, float> &imag);


    IA_Image(const IA_Image& im)
    :IA_CoreImage<IA_Point<int>, complex>(im) {}

    IA_Image(IA_Set<IA_Point<int> > ps, complex value)
    :IA_CoreImage<IA_Point<int>, complex>(ps,(complex)value) {}

    IA_Image(IA_Set<IA_Point<int> > ps, complex *vp, unsigned sz,
			  int giveaway=0)
    :IA_CoreImage<IA_Point<int>, complex>(ps, vp, sz, giveaway) {}

    IA_Image(IA_Set<IA_Point<int> > ps, const complex *vp, unsigned sz)
    :IA_CoreImage<IA_Point<int>, complex>(ps, vp, sz) {}

    IA_Image(const IA_ClosureI<IA_Point<int>, complex> &img)
    :IA_CoreImage<IA_Point<int>, complex>(img) {}

    IA_Image(IA_Set<IA_Point<int> > ps, complex (*f)(const IA_Point<int>&))
    :IA_CoreImage<IA_Point<int>, complex>(ps,f) {}

    IA_Image( const IA_CoreImage<IA_Point<int>, complex> &d)
    :IA_CoreImage<IA_Point<int>, complex>(d) {}



    virtual ~IA_Image(){ }

#include	"CplxIOps.h"
};

inline int operator!=(const IA_CoreImage<IA_Point<int>,complex> &lhs,
		      const IA_CoreImage<IA_Point<int>,complex> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_CoreImage<IA_Point<int>,complex> &lhs,
		      complex rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(complex lhs,
		      const IA_CoreImage<IA_Point<int>,complex> &rhs) {
    return ! (rhs == lhs);
}

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_CoreImage<IA_Point<int>, complex>&);


#endif
