// sis_Specials.c       Section: 3.8
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Special definitions for the sis function.
//

#include "sis.h"

// A special definition for this function, as per
//       The C++ Programming Language, p. 272
// Here is the special definition for u_char ....
//

// IA_Image<P,u_char> is a special case because the template has
//   -1 values, which, of course, u_char can not hold.

u_char
sis_threshold( const IA_Image<IA_Point<int>,u_char> & a ) {

    return
	u_char( sis_threshold( IA_Image<IA_Point<int>,int>( a ) ) );
}
