// otsu.h               Section: 3.7
// Threshold Selection by Maximizing Between Class Variance
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.


#ifndef otsu_h_
#define otsu_h_

#include "IntDI.h"
#include "UcharDI.h"

/////////////////////////////////////////////////////////////////////
// otsu()
// This function is given an image and a count of the number of
//      partition thresholds desired for the image.  It returns
//      a point set, with dimension one less than  partitionCount.
//      Each point in the point set maybe interpreted as a possible
//      partitioning of the image.  The coordinate value of each
//      point represents the Tau values defined by the Otsu algorithm.
//
template <class P, class T>
IA_Set<IA_Point<int> >
otsu( unsigned int partitionCount, const IA_Image<P,T> & a );

#endif
