// mat.h                Section: 4.4  Medial Axis Transform (MAT)
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Medial Axis Transform

#ifndef mat_h_
#define mat_h_

#include "IntPS.h"
#include "BitDI.h"
#include "IntDI.h"


/////////////////////////////////////////////////////////////////////
// medial_axis()
//      1st argument: The input image
//      2nd argument: The point set which represents the ball to
//                    use in calculating the medial axis transform
//      3rd argument: A reference argument used to pass back
//                    the number of iterations required to calculate
//                    the medial axis transform
//      result      : The medial axis image is returned

IA_Image<IA_Point<int>,int>
medial_axis( const IA_Image<IA_Point<int>,IA_Bit> & aImage,
	     const IA_Set<IA_Point<int> > & ball,
	     unsigned int & count );


/////////////////////////////////////////////////////////////////////
// inverse_medial_axis()
//      1st argument: The input medial axis image
//      2nd argument: Point set that represents the ball used
//                    in calculating the medial axis transform


IA_Image<IA_Point<int>,IA_Bit>
inverse_medial_axis( const IA_Image<IA_Point<int>,int> & m,
		     const IA_Set<IA_Point<int> > & ball );
#endif
