// snp.c                Section: 5.4
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Salt-and-Pepper-Noise-Removal algorithm.
// This implementation takes advantage of the fact that the algorithm
//      is defined with a characteristic template, and hence a
//      neighborhood reduction may be employed.


#include "Nbh.h"
#include "shaped-pointset.h"
#include "snp.h"


IA_Image<IA_Point<int>,IA_Bit>
snp( const IA_Image<IA_Point<int>,IA_Bit> & a ) {

    unsigned int a_dim = a.domain().dim();

    // Create the neighborhood
    IA_Neighborhood<IA_Point<int>,IA_Point<int> >
	snp_nbhd( a_dim,
		  cross_hair( extend_to_point( 0, a_dim ),
			      1 )
		  );

    // We will apply the algorithm in steps, for readability
    IA_Image<IA_Point<int>,IA_Bit>
	b( min( a, snp_nbhd ) );
    b = max( b, snp_nbhd );
    b = max( b, snp_nbhd );

    // we simply return the final result
    return
	min( b, snp_nbhd );
}
