// File: max-min.h      Section: 2.6
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Max-Min Sharpening Transform

#ifndef _max_min_h_
#define _max_min_h_

#include "UcharDI.h"
#include "IntDI.h"
#include "FloatDI.h"
#include "Nbh.h"


////////////////////////////////////////////////////////////////////////
// max_min_sharpening(image,neighborhood,iteration_count)
// Execute the max-min sharpening algorithm for iteration_count
//      number of loops and returns the sharpened image.
// Note: For an iteractive use of this algorithm, it would be
//      possible to feed the result image back in and always
//      set iteration_count = 1  (or greater, as desired).
//

template <class P, class T>
IA_Image<P,T>
max_min_sharpening( const IA_Image<P,T> &image,
		    const IA_Neighborhood<P,P> &neighborhood,
		    const unsigned int iteration_count );

#endif
