// mat.h                Section: 4.4
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Medial Axis Transform

#ifndef mat_h_
#define mat_h_

#include "IntPS.h"
#include "BitDI.h"
#include "IntDI.h"


/////////////////////////////////////////////////////////////////////
// medial_axis()
//      1st argument: The input image
//      2nd argument: The point set to be used to calculate
//                    the medial axis transform
//      3rd argument: A reference argument used to pass back
//                    the number of iterations required to calculate
//                    the medial axis transform
//      result      : The medial axis image is returned

IA_Image<IA_Point<int>,int>
medial_axis( const IA_Image<IA_Point<int>,IA_Bit> & a,
	     const IA_Set<IA_Point<int> > & ps,
	     unsigned int & count );


/* NOT CURRENTLY IMPLEMENTED  ****************************************
/////////////////////////////////////////////////////////////////////
// inverse_medial_axis()
//      1st argument: The input image
//      2nd argument: The point set to be used to calculate
//                    the inverse medial axis transform
//      3rd argument: The count as returned back by medial_axis()
//      result      : The inverse medial axis image is returned

IA_Image<IA_Point<int>,IA_Bit>
inverse_media_axis( const IA_Image<IA_Point<int>,u_char> & m,
		    const IA_Set<IA_Point<int> > & ps,
		    const unsigned int count );

**********************************************************************/
#endif
