// life.h               Section: 14.2
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// The game of life as described by John Conway.

#ifndef _life_h_
#define _life_h_

#include "UcharDI.h"
#include "DDTempl.h"


// Note that by using a different template or different set of
//      values the rules for the game of "life" can be quite
//      easily changed.  Because of this this interface will
//      have two versions.
// The first assumes the standard game, and follows those rules.
// The second simply assumes the correct way to play the game
//      is by performing a linear_product and a chi test.
// Both versions allow more than one interation to be requested.

// Note: If the function will be called many time by calling
//      routine, it will be more efficient to define the template
//      in the calling routine and use the second version of the
//      life() routinue.

// Return a template as defined by in the section.
IA_DDTemplate<IA_Image<IA_Point<int>,u_char> >
standard_life_template();


IA_Image<IA_Point<int>,u_char>
life( const IA_Image<IA_Point<int>,u_char> & citizens,
      unsigned int iterations = 1 );


IA_Image<IA_Point<int>,u_char>
life( const IA_Image<IA_Point<int>,u_char> & citizens,
      const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > & rules,
      const IA_Set<u_char> & limits,
      unsigned int iterations = 1 );

#endif
