// Emacs -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: metacode,v $
// Revision 1.2.1.1  1994/12/08  14:52:40  thoth
// Intersection between comprehensive and extensive can yield
// extensive result.
//
// Revision 1.2  1994/10/19  15:20:00  thoth
// Seems we need to declare a couple of the classes we use.
//
// Revision 1.1  1994/10/06  19:28:08  thoth
// Initial revision
//

#include "OpTable.h"
#include "Set.h"
#include "BaseSet.h"
#include "LazySet.h"
#include "ValueSet.h"
#include "BSetIter.h"

#include "RGB.h"
#include "Bit.h"
#include <complex.h>

IA_HomogenousBinaryOperationsTable<IA_BaseSet<IA_Bit> > * IA_Set_IA_Bit_XOR_tbl;

static IA_HomogenousBinaryOperationsTable<IA_BaseSet<IA_Bit> > *&curr_tbl = IA_Set_IA_Bit_XOR_tbl;

void IA_fill_Set_IA_Bit_XOR_table();

IA_Set<IA_Bit> operator^(const IA_Set<IA_Bit> &lhs, const IA_Set<IA_Bit> &rhs)
{
    if (! curr_tbl) {
	IA_fill_Set_IA_Bit_XOR_table();
    }

    IA_BaseSet<IA_Bit> *(*f)(IA_BaseSet<IA_Bit> &, IA_BaseSet<IA_Bit>&);
    f = curr_tbl
	->lookup_operation(lhs.bsp->type(), rhs.bsp->type());

    return f(*lhs.bsp, *rhs.bsp);
}

//
//
//


template <class T>
inline IA_BaseSet<T>*
intersect_valueset(IA_BaseSet<T>&a_, IA_BaseSet<T>&b_) {
    return new IA_ValueSet<T>(*(IA_ValueSet<T> *)&a_
			      &
			      *(IA_ValueSet<T> *)&b_);
}

#if (OPNUM==1)

// #define FRIENDLY

static IA_BaseSet<IA_Bit>*
intersect_valueset_w_generic(IA_BaseSet<IA_Bit>&a_, IA_BaseSet<IA_Bit>&b_) {
    IA_Bit	*vals = new IA_Bit[a_.card()];
    int	count=0;
#ifdef FRIENDLY
    IA_ValueSet<IA_Bit> *a = (IA_ValueSet<IA_Bit> *)&a_;
    for (int i=0; i<a->size; i++) {
	if (b_->contains(a->value_array[i]))
	    vals[count++] = a->value_array[i];
    }
#else
    {
	IA_BaseSetIter<IA_Bit>	*iter = a_.iterator();
	IA_Bit	val;
	while (iter->next(val)) {
	    if (b_.contains(val))
		vals[count++] = val;
	}
	delete iter;
    }
#endif
    IA_BaseSet<IA_Bit> *rval = new IA_ValueSet<IA_Bit>(vals, count);
    delete[] vals;
    return rval;
}

static IA_BaseSet<IA_Bit>*
intersect_generic_w_valueset(IA_BaseSet<IA_Bit>&b_, IA_BaseSet<IA_Bit>&a_) {
    IA_Bit	*vals = new IA_Bit[a_.card()];
    int	count=0;
#ifdef FRIENDLY
    IA_ValueSet<IA_Bit> *a = (IA_ValueSet<IA_Bit> *)&a_;
    for (int i=0; i<a->size; i++) {
	if (b_->contains(a->value_array[i]))
	    vals[count++] = a->value_array[i];
    }
#else
    {
	IA_BaseSetIter<IA_Bit>	*iter = a_.iterator();
	IA_Bit	val;
	while (iter->next(val)) {
	    if (b_.contains(val))
		vals[count++] = val;
	}
	delete iter;
    }
#endif
    IA_BaseSet<IA_Bit> *rval = new IA_ValueSet<IA_Bit>(vals, count);
    delete[] vals;
    return rval;
}

static IA_BaseSet<IA_Bit>*
 intersect_generic_set(IA_BaseSet<IA_Bit>&a, IA_BaseSet<IA_Bit>&b)
{
    if (a.extensive()) {
	if (a.empty())
	    return new IA_ValueSet<IA_Bit>((IA_Bit*)0, 0);

	IA_Bit	*vals = new IA_Bit[a.card()]; // can\'t really be bigger...
	int	count=0;

	if (b.extensive()) {

	    if (b.empty())
		return new IA_ValueSet<IA_Bit>((IA_Bit*)0, 0);

	    IA_BaseSetIter<IA_Bit>	*a_iter = a.iterator();
	    IA_BaseSetIter<IA_Bit>	*b_iter = b.iterator();
	    IA_Bit	a_val, b_val;

	    if (! (a_iter->next(a_val) && b_iter->next(b_val)) )
		IA::internal_error(__FILE__,__LINE__);

	    while (1) {
		int	comp;
		comp = IA_ValueSet<IA_Bit>::value_type_compare(&a_val, &b_val);
		if (comp<0) {
		    if (!a_iter->next(a_val))	break; // ran out of values
		} else if (comp>0) {
		    if (!b_iter->next(b_val))	break; // ran out of values
		} else /* comp==0 */ {
		    vals[count++] = a_val; // ==b_val
		    if (! (a_iter->next(a_val) && b_iter->next(b_val)) )
			break;	// ran out of values
		}
	    }
	    delete a_iter;
	    delete b_iter;

	    IA_ValueSet<IA_Bit>	*rval;
	    rval = new IA_ValueSet<IA_Bit>(vals, count);
	    delete[] vals;

	    return rval;
	} else /* b.!extensive() */ {
	    IA_BaseSetIter<IA_Bit>	*iter = a.iterator();
	    IA_Bit	val;
	    while (iter->next(val)) {
		if (b.contains(val))
		    vals[count++] = val;
	    }
	    delete iter;

	    IA_ValueSet<IA_Bit>	*rval;
	    rval = new IA_ValueSet<IA_Bit>(vals, count);
	    delete[] vals;

	    return rval;
	}

    } else /* a.!extensive() */ {
	if (b.extensive()) {
	    if (b.empty())
		return new IA_ValueSet<IA_Bit>((IA_Bit*)0, 0);

	    IA_Bit	*vals = new IA_Bit[b.card()]; // can\'t really be bigger.
	    int	count=0;

	    IA_BaseSetIter<IA_Bit>	*iter = b.iterator();
	    IA_Bit	val;
	    while (iter->next(val)) {
		if (a.contains(val))
		    vals[count++] = val;
	    }
	    delete iter;

	    IA_ValueSet<IA_Bit>	*rval;
	    rval = new IA_ValueSet<IA_Bit>(vals, count);
	    delete[] vals;

	    return rval;
	} else  /* b.!extensive() */{
	    return new IA_LazyIntersectionSet<IA_Bit>(&a, &b);
	}
    }
}

#endif // OPNUM==1


//
//
//


template <class T>
inline IA_BaseSet<T>*
 union_generic_set(IA_BaseSet<T>&a, IA_BaseSet<T>&b) {
    return new IA_LazyUnionSet<T>(&a, &b);
}


template <class T>
inline IA_BaseSet<T>*
union_valueset(IA_BaseSet<T>&a_, IA_BaseSet<T>&b_) {
    return new IA_ValueSet<T>(*(IA_ValueSet<T> *)&a_
			      |
			      *(IA_ValueSet<T> *)&b_);
}

//
//
//


template <class T>
inline IA_BaseSet<T>*
 XOR_generic_set(IA_BaseSet<T>&a, IA_BaseSet<T>&b) {
    return new IA_LazyXORSet<T>(&a, &b);
}


template <class T>
inline IA_BaseSet<T>*
XOR_valueset(IA_BaseSet<T>&a_, IA_BaseSet<T>&b_) {
    return new IA_ValueSet<T>(*(IA_ValueSet<T> *)&a_
			      ^
			      *(IA_ValueSet<T> *)&b_);
}

//
//
//


template <class T>
inline IA_BaseSet<T>*
 minus_generic_set(IA_BaseSet<T>&a, IA_BaseSet<T>&b) {
    return new IA_LazyMinusSet<T>(&a, &b);
}


template <class T>
inline IA_BaseSet<T>*
minus_valueset(IA_BaseSet<T>&a_, IA_BaseSet<T>&b_) {
    return new IA_ValueSet<T>(*(IA_ValueSet<T> *)&a_
			      /
			      *(IA_ValueSet<T> *)&b_);
}

#if (OPNUM==2)

static IA_BaseSet<IA_Bit>*
minus_valueset_w_generic(IA_BaseSet<IA_Bit>&a_, IA_BaseSet<IA_Bit>&b_) {
    IA_Bit	*vals = new IA_Bit[a_.card()];
    int	count=0;
#ifdef FRIENDLY
    IA_ValueSet<IA_Bit> *a = (IA_ValueSet<IA_Bit> *)&a_;
    for (int i=0; i<a->size; i++) {
	if (b_->contains(a->value_array[i]))
	    vals[count++] = a->value_array[i];
    }
#else
    {
	IA_BaseSetIter<IA_Bit>	*iter = a_.iterator();
	IA_Bit	val;
	while (iter->next(val)) {
	    if (!b_.contains(val))
		vals[count++] = val;
	}
	delete iter;
    }
#endif
    IA_BaseSet<IA_Bit> *rval = new IA_ValueSet<IA_Bit>(vals, count);
    delete[] vals;
    return rval;
}

#endif // OPNUM==2

//
//
//


void IA_fill_Set_IA_Bit_XOR_table()
{
    if (curr_tbl)
	return;

    IA_BaseSet<IA_Bit> *(*f)(IA_BaseSet<IA_Bit>&, IA_BaseSet<IA_Bit>&);
    f = XOR_generic_set;
    curr_tbl = new IA_HomogenousBinaryOperationsTable
	< IA_BaseSet<IA_Bit> >
	    ( f );
    curr_tbl->add_operation
	(IA_ValueSet<IA_Bit>::s_type(),IA_ValueSet<IA_Bit>::s_type(),
	 XOR_valueset);
#if (OPNUM == 1) || (OPNUM==2)
    curr_tbl->add_operation
	(IA_ValueSet<IA_Bit>::s_type(), 0,
	 XOR_valueset_w_generic);
#endif
#if (OPNUM == 1)
    curr_tbl->add_operation
	( 0, IA_ValueSet<IA_Bit>::s_type(),
	 XOR_generic_w_valueset);
#endif
}
