// Emacs -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: BSetIter.c,v $
// Revision 1.2  1994/10/05  16:21:09  ljr
// added #include "BSetIter.h" for BC++
//
// Revision 1.1  1994/10/03  21:01:43  thoth
// Initial revision
//

#include "BSetIter.h"

template <class T>
IA_BaseSetIter<T>::IA_BaseSetIter(IA_BaseSet<T> *set)
: domain(set) {
    domain->incr_ref();
}

template <class T>
IA_BaseSetIter<T>::IA_BaseSetIter(const IA_BaseSetIter<T> &iter)
:domain(iter.domain)
{
    domain->incr_ref();
}

template <class T>
IA_BaseSetIter<T>::~IA_BaseSetIter()
{
    if (domain->decr_ref() <= 0) {
	delete domain;
    }
    // domain = 0;
}

#if 0
// we will never be doing this
template <class T>
IA_BaseSetIter<T>&
IA_BaseSetIter<T>::operator=(const IA_BaseSetIter<T> &arg)
{
    IA_BaseSet<T>	*temp = domain;

    domain = arg.domain;
    domain->incr_ref();

    if (temp->decr_ref() <= 0)
	delete temp;

    return *this;
}

#endif
