// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: float-operations.desc,v $
//  Revision 1.11.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.11.1.1  1994/12/28  18:05:25  thoth
//  image operations are now friendly with FBI.
//  image ops now use operations table
//  new sgn() function.

//  Revision 1.11  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.10  1994/10/14  20:43:19  thoth
//  The inline is much more useful in the header file.

//  Revision 1.9  1994/09/16  14:59:10  thoth
//  add fabs(image)

//  Revision 1.8  1994/07/08  16:14:11  thoth
//  fixed problems caused by returning floats instead of doubles.

//  Revision 1.7  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Float operations for the Float Discrete Image
#include "FloatDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
inline double max(double a, double b)
{
    return (a<b)?b:a;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(float) I(float) I(float)
//
#ifndef BOT_float_float_float_max
#define BOT_float_float_float_max
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_float_max_tbl;

void IA_fill_Image_IP_float_float_float_max_tbl();

#endif // BOT_float_float_float_max
IA_Image<IA_Point<int>, float>
max ( const IA_Image<IA_Point<int>, float> &lhs,
		const IA_Image<IA_Point<int>, float> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, float>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_float_float_float_max_tbl)
	IA_fill_Image_IP_float_float_float_max_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)( IA_BaseImage<IA_Point<int>, float> &,
		IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_float_max_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,float>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,float>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,float>
	(IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, float> *
vec_vec_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, float> *rhs
		= (IA_VectorI<IA_Point<int>, float> *)&rhs_;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*ls, *rs);
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_max
#define vec_scalar_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
vec_scalar_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_max

static IA_BaseImage<IA_Point<int>, float> *
vec_iter_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = max(*ls, rtmp);
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}

#ifndef scalar_vec_float_float_float_max
#define scalar_vec_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
scalar_vec_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return vec_scalar_bo_max(rhs_, lhs_);
}
#endif // scalar_vec_float_float_float_max

#ifndef scalar_scalar_float_float_float_max
#define scalar_scalar_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
scalar_scalar_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
    float	aval = max( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, float>(domain, aval);
}
#endif // scalar_scalar_float_float_float_max

#ifndef scalar_iter_float_float_float_max
#define scalar_iter_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
scalar_iter_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = max(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_max

static IA_BaseImage<IA_Point<int>, float> *
iter_vec_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return vec_iter_bo_max(rhs_, lhs_);
}

#ifndef iter_scalar_float_float_float_max
#define iter_scalar_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
iter_scalar_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return scalar_iter_bo_max(rhs_, lhs_);
}
#endif // iter_scalar_float_float_float_max

static IA_BaseImage<IA_Point<int>, float> *
iter_iter_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs_.value_iterator();
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = max(ltmp, rtmp);
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_float_float_float_max
#define FILL_BOT_float_float_float_max
void IA_fill_Image_IP_float_float_float_max_tbl()
{
    if (IA_Image_IP_float_float_float_max_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_iter_bo_max;

    IA_Image_IP_float_float_float_max_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >(iter_iter_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_vec_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 vec_scalar_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 0,
	 vec_iter_bo_max);

    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 scalar_vec_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_scalar_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 0,
	 scalar_iter_bo_max);

    IA_Image_IP_float_float_float_max_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 iter_vec_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 iter_scalar_bo_max);

}
#endif // BOT_float_float_float_max

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(float) I(float) float
//
#ifndef BOT_float_float_float_max
#define BOT_float_float_float_max
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_float_max_tbl;

void IA_fill_Image_IP_float_float_float_max_tbl();

#endif // BOT_float_float_float_max
IA_Image<IA_Point<int>, float>
max ( const IA_Image<IA_Point<int>, float> &lhs,
		float rhs)
{
    if (!IA_Image_IP_float_float_float_max_tbl)
	IA_fill_Image_IP_float_float_float_max_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)( IA_BaseImage<IA_Point<int>, float> &,
		IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_float_max_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, float>::s_type());
    IA_BaseImage<IA_Point<int>,float>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,float>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,float>
	(IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_float_float_float_max
#define vec_scalar_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
vec_scalar_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_max

#ifndef scalar_scalar_float_float_float_max
#define scalar_scalar_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
scalar_scalar_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
    float	aval = max( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, float>(domain, aval);
}
#endif // scalar_scalar_float_float_float_max

#ifndef scalar_iter_float_float_float_max
#define scalar_iter_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
scalar_iter_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = max(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_max

#ifndef iter_scalar_float_float_float_max
#define iter_scalar_float_float_float_max
static IA_BaseImage<IA_Point<int>, float> *
iter_scalar_bo_max(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return scalar_iter_bo_max(rhs_, lhs_);
}
#endif // iter_scalar_float_float_float_max

#ifndef FILL_BOT_float_float_float_max
#define FILL_BOT_float_float_float_max
void IA_fill_Image_IP_float_float_float_max_tbl()
{
    if (IA_Image_IP_float_float_float_max_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_iter_bo_max;

    IA_Image_IP_float_float_float_max_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >(iter_iter_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_vec_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 vec_scalar_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 0,
	 vec_iter_bo_max);

    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 scalar_vec_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_scalar_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 0,
	 scalar_iter_bo_max);

    IA_Image_IP_float_float_float_max_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 iter_vec_bo_max);
    IA_Image_IP_float_float_float_max_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 iter_scalar_bo_max);

}
#endif // BOT_float_float_float_max

inline double min(double a, double b)
{
    return (a<b)?a:b;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(float) I(float) I(float)
//
#ifndef BOT_float_float_float_min
#define BOT_float_float_float_min
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_float_min_tbl;

void IA_fill_Image_IP_float_float_float_min_tbl();

#endif // BOT_float_float_float_min
IA_Image<IA_Point<int>, float>
min ( const IA_Image<IA_Point<int>, float> &lhs,
		const IA_Image<IA_Point<int>, float> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, float>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_float_float_float_min_tbl)
	IA_fill_Image_IP_float_float_float_min_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)( IA_BaseImage<IA_Point<int>, float> &,
		IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_float_min_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,float>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,float>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,float>
	(IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, float> *
vec_vec_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, float> *rhs
		= (IA_VectorI<IA_Point<int>, float> *)&rhs_;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*ls, *rs);
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_min
#define vec_scalar_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
vec_scalar_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_min

static IA_BaseImage<IA_Point<int>, float> *
vec_iter_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = min(*ls, rtmp);
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}

#ifndef scalar_vec_float_float_float_min
#define scalar_vec_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
scalar_vec_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return vec_scalar_bo_min(rhs_, lhs_);
}
#endif // scalar_vec_float_float_float_min

#ifndef scalar_scalar_float_float_float_min
#define scalar_scalar_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
scalar_scalar_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
    float	aval = min( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, float>(domain, aval);
}
#endif // scalar_scalar_float_float_float_min

#ifndef scalar_iter_float_float_float_min
#define scalar_iter_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
scalar_iter_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = min(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_min

static IA_BaseImage<IA_Point<int>, float> *
iter_vec_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return vec_iter_bo_min(rhs_, lhs_);
}

#ifndef iter_scalar_float_float_float_min
#define iter_scalar_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
iter_scalar_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return scalar_iter_bo_min(rhs_, lhs_);
}
#endif // iter_scalar_float_float_float_min

static IA_BaseImage<IA_Point<int>, float> *
iter_iter_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs_.value_iterator();
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = min(ltmp, rtmp);
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_float_float_float_min
#define FILL_BOT_float_float_float_min
void IA_fill_Image_IP_float_float_float_min_tbl()
{
    if (IA_Image_IP_float_float_float_min_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_iter_bo_min;

    IA_Image_IP_float_float_float_min_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >(iter_iter_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_vec_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 vec_scalar_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 0,
	 vec_iter_bo_min);

    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 scalar_vec_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_scalar_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 0,
	 scalar_iter_bo_min);

    IA_Image_IP_float_float_float_min_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 iter_vec_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 iter_scalar_bo_min);

}
#endif // BOT_float_float_float_min

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(float) I(float) float
//
#ifndef BOT_float_float_float_min
#define BOT_float_float_float_min
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_float_min_tbl;

void IA_fill_Image_IP_float_float_float_min_tbl();

#endif // BOT_float_float_float_min
IA_Image<IA_Point<int>, float>
min ( const IA_Image<IA_Point<int>, float> &lhs,
		float rhs)
{
    if (!IA_Image_IP_float_float_float_min_tbl)
	IA_fill_Image_IP_float_float_float_min_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)( IA_BaseImage<IA_Point<int>, float> &,
		IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_float_min_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, float>::s_type());
    IA_BaseImage<IA_Point<int>,float>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,float>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,float>
	(IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_float_float_float_min
#define vec_scalar_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
vec_scalar_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_VectorI<IA_Point<int>, float> *lhs
		= (IA_VectorI<IA_Point<int>, float> *)&lhs_;
	const float *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_min

#ifndef scalar_scalar_float_float_float_min
#define scalar_scalar_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
scalar_scalar_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	IA_ConstI<IA_Point<int>, float> *rhs
		= (IA_ConstI<IA_Point<int>, float> *)&rhs_;
    float	aval = min( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, float>(domain, aval);
}
#endif // scalar_scalar_float_float_float_min

#ifndef scalar_iter_float_float_float_min
#define scalar_iter_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
scalar_iter_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_ConstI<IA_Point<int>, float> *lhs
		= (IA_ConstI<IA_Point<int>, float> *)&lhs_;
	float rtmp;
	IA_BaseIVIter<IA_Point<int>, float>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = min(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_min

#ifndef iter_scalar_float_float_float_min
#define iter_scalar_float_float_float_min
static IA_BaseImage<IA_Point<int>, float> *
iter_scalar_bo_min(IA_BaseImage<IA_Point<int>, float> &lhs_,
	IA_BaseImage<IA_Point<int>, float> &rhs_)
{
    return scalar_iter_bo_min(rhs_, lhs_);
}
#endif // iter_scalar_float_float_float_min

#ifndef FILL_BOT_float_float_float_min
#define FILL_BOT_float_float_float_min
void IA_fill_Image_IP_float_float_float_min_tbl()
{
    if (IA_Image_IP_float_float_float_min_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_iter_bo_min;

    IA_Image_IP_float_float_float_min_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float>,
	IA_BaseImage<IA_Point<int>, float> >(iter_iter_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_vec_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 vec_scalar_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 0,
	 vec_iter_bo_min);

    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 scalar_vec_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_scalar_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 0,
	 scalar_iter_bo_min);

    IA_Image_IP_float_float_float_min_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, float>::s_type(),
	 iter_vec_bo_min);
    IA_Image_IP_float_float_float_min_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, float>::s_type(),
	 iter_scalar_bo_min);

}
#endif // BOT_float_float_float_min

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename FIO-reduce.c
//
