// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: bit-operations.desc,v $
//  Revision 1.6.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.6.1.1  1994/12/28  17:49:18  thoth
//  Image operations are now friendly with FBI.
//  Image ops now use operations table instead of switch.

//  Revision 1.6  1994/08/22  15:20:29  thoth
//  DOS-inspired name rework.

//  Revision 1.5  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Revision 1.4  1994/02/03  16:22:48  thoth
//  Arguments to binary operations were specified "lhs rhs return" but are
//  now specified "return lhs rhs" to be consistent with function declaration
//  syntax.

//  Revision 1.3  1994/01/31  15:51:12  thoth
//  converters to CoreImages now available.

//  Revision 1.2  1993/12/29  17:16:45  thoth
//  Bit Discrete Image now uses Bit type.

//  Revision 1.1  1993/11/29  22:25:25  thoth
//  Initial revision


#include "BitDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
#ifdef __BROKEN_TYPE_CONVERSION
inline int operator+(int a, IA_Bit b) { return a + int(b); }
#endif
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction sum subop=operator+ zero=0 int I(IA_Bit)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_op_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:43  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:05:07  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

#ifndef REDUCE_int_IA_Bit_sum
#define REDUCE_int_IA_Bit_sum
IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit> >
	*IA_Image_IP_int_IA_Bit_sum_tbl;

void IA_fill_Image_IP_int_IA_Bit_sum_tbl();
#endif // REDUCE_int_IA_Bit_sum


int sum ( const IA_Image<IA_Point<int>, IA_Bit> &arg)
{
    if (!IA_Image_IP_int_IA_Bit_sum_tbl)
	IA_fill_Image_IP_int_IA_Bit_sum_tbl();

    int(*f)
	(IA_BaseImage<IA_Point<int>, IA_Bit> &);
    f = IA_Image_IP_int_IA_Bit_sum_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, IA_Bit>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,IA_Bit,IA_Bit,IA_Bit>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_int_IA_Bit_sum
#define vec_reduce_int_IA_Bit_sum
static int
vec_reduce_sum(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_)
{
    const IA_VectorI<IA_Point<int>, IA_Bit> *lhs =
	(IA_VectorI<IA_Point<int>, IA_Bit> *) &lhs_;

    const IA_Bit *ls = lhs->vec;

    int	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = rval + (*(ls++));
    }

    return rval;
}
#endif // vec_reduce_int_IA_Bit_sum

#ifndef scalar_reduce_int_IA_Bit_sum
#define scalar_reduce_int_IA_Bit_sum
static int
scalar_reduce_sum(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_)
{
    const IA_ConstI<IA_Point<int>, IA_Bit> *lhs =
	(IA_ConstI<IA_Point<int>, IA_Bit> *) &lhs_;

    int	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = rval + lhs->value;

    return rval;
}
#endif // scalar_reduce_int_IA_Bit_sum

// scalar-scalar operation is trivial

#ifndef iter_reduce_int_IA_Bit_sum
#define iter_reduce_int_IA_Bit_sum
static int
iter_reduce_sum(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs)
{
    const unsigned sz = lhs.domain().card();

    IA_Bit ltmp;
    IA_BaseIVIter<IA_Point<int>, IA_Bit>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    int	rval=ltmp;

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = rval + ltmp;
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_int_IA_Bit_sum

#ifndef FILL_REDUCE_int_IA_Bit_sum
#define FILL_REDUCE_int_IA_Bit_sum
void IA_fill_Image_IP_int_IA_Bit_sum_tbl()
{
    if (IA_Image_IP_int_IA_Bit_sum_tbl)
	return;

    IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit> >::function f;
    f = iter_reduce_sum;

    IA_Image_IP_int_IA_Bit_sum_tbl = new IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit> >(iter_reduce_sum);
    IA_Image_IP_int_IA_Bit_sum_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 vec_reduce_sum);
    IA_Image_IP_int_IA_Bit_sum_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 scalar_reduce_sum);

}
#endif // REDUCE_int_IA_Bit_sum

#if 0

static int vec_reduce_sum(const IA_VectorI<IA_Point<int>, IA_Bit> *arg)
{
    const IA_Bit *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) +  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_IA_Bit_sum
#define const_reduce_int_IA_Bit_sum
static int const_reduce_sum(unsigned sz, IA_Bit arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) + arg);
    }
    return rval;
}
#endif

static int iter_reduce_sum(const IA_Image<IA_Point<int>, IA_Bit> &arg)
{
    IA_IVIter<IA_Point<int>, IA_Bit>	iter(arg);

    IA_Bit	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) +  temp);
    }

    return rval;
}

int sum ( const IA_Image<IA_Point<int>, IA_Bit> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 0 );
    IA_Image<IA_Point<int>, IA_Bit>	arg(arg_);

    IA_BaseImage<IA_Point<int>, IA_Bit>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,IA_Bit,IA_Bit,IA_Bit>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, IA_Bit>::s_type()) {
	return vec_reduce_sum((IA_VectorI<IA_Point<int>, IA_Bit> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, IA_Bit>::s_type()) {
	return const_reduce_sum
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, IA_Bit> *)bip)->value);
    } else {
	return iter_reduce_sum(arg);
    }
}

#endif

