// Emacs -*- C++ -*-

//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

// $Log: compat.c,v $
// Revision 1.5  1994/11/30  15:53:57  thoth
// Removed decorative static char[]s.
// removed extra RCS Log entry as it was causing duplicate substitutions
// upon revision checkin.
//
// Revision 1.4  1994/11/10  18:47:59  ljr
// Added IA_NO_RCS_STATIC_DATA guard.
//
// Revision 1.3  1994/08/18  13:53:01  ljr
// Added missing #endif for #ifdef IA_NEED_IRINT
//
// Revision 1.2  1994/08/17  02:01:47  gmt
// Added the RCS Log comment.
// Also wrapped ifdefs around each function so taht they do not exist unless
// they are needed.  These are to match the ifdefs in compat.h.
//

#include <stdlib.h>
#include "compat.h"

#ifdef IA_NEED_AINT
// aint() returns the integral value between x and 0, nearest x
double aint(double x)
{
   return (double)((int)x);
}
#endif

#ifdef IA_NEED_NINT
// nint() converts x into int format rounding to the nearest int value,
// except halfway cases are rounded to the int value larger in magnitude
int nint(double x)
{
   return (x > 0)? (int)(x + .5) : (int)(x - .5);
}
#endif

#ifdef IA_NEED_ANINT
// anint() returns the nearest integral value to x, except halfway cases
// are rounded to the integral value larger in magnitude
double anint(double x)
{
   return (double)((x > 0)? (int)(x + .5) : (int)(x - .5));
}
#endif

#ifdef IA_NEED_RINT
// rint() returns the nearest integral value to x, except halfway cases are
// rounded to an even digit (banker's rounding)
double rint(double x)
{
   return (abs((int)x) % 2)?
      anint(x) : (x+.5 == aint(x+.5))? aint(x) : anint(x);
}
#endif

#ifdef IA_NEED_IRINT
// irint() converts x into int format rounding to the nearest int value,
// except halfway cases are rounded to an even digit (banker's rounding)
int irint(double x)
{
   return (int)((abs((int)x) % 2)?
      anint(x) : (x+.5 == aint(x+.5))? aint(x) : anint(x));
}
#endif
