// Emacs: -*- C++ -*-

// 	Copyright 1994, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.

// $Log: RGB.c,v $
// Revision 1.2  1994/11/10  18:47:27  ljr
// Added IA_NO_RCS_STATIC_DATA guard.
//
// Revision 1.1  1994/04/15  17:44:26  jnw
// Initial revision
//

#ifndef IA_NO_RCS_STATIC_DATA
static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char rcsid[] = "$Id: RGB.c,v 1.2 1994/11/10 18:47:27 ljr Exp $";
#endif

#include "RGB.h"

unsigned char IA_RGB_red_vec [256] = {
18,18,18,18,18,18,18,18,
19,19,19,19,20,20,21,21,
22,23,24,24,25,25,26,27,
28,29,30,31,32,33,34,35,
36,37,39,40,41,42,44,45,
46,47,49,50,52,53,55,56,
58,59,61,62,64,66,68,69,
71,73,75,76,78,80,82,84,
86,88,90,92,94,95,97,99,
101,103,105,107,109,111,113,115,
117,119,121,123,125,127,130,132,
134,136,138,140,142,144,146,148,
150,152,154,156,158,159,161,163,
165,167,169,171,173,175,177,178,
180,182,184,185,187,189,191,192,
194,195,197,198,200,201,203,204,
206,207,209,210,211,212,214,215,
216,217,219,220,221,222,223,224,
225,226,227,228,229,229,230,230,
231,232,233,233,234,234,235,235,
236,236,236,236,237,237,237,237,
237,237,238,237,237,237,237,237,
237,236,236,236,236,235,235,234,
234,233,233,232,231,230,230,229,
229,228,227,226,225,224,223,222,
221,220,219,217,216,215,214,212,
211,210,209,207,206,204,203,201,
200,198,197,195,194,192,191,189,
187,185,184,182,180,178,177,175,
173,171,169,167,165,163,161,159,
158,156,154,152,150,148,146,144,
142,140,138,136,134,132,130,128};

unsigned char IA_RGB_green_vec [256] = {
128,130,132,134,136,138,140,142,
144,146,148,150,152,154,156,158,
160,161,163,165,167,169,171,173,
175,176,178,180,182,183,185,187,
189,190,192,193,195,197,199,200,
202,203,205,206,207,208,210,211,
213,214,215,216,218,219,220,221,
222,223,224,225,226,227,228,228,
229,230,231,231,232,232,233,233,
234,234,235,235,236,236,237,237,
237,237,237,237,237,237,237,237,
237,237,237,237,237,236,236,235,
235,234,234,233,233,232,232,231,
231,230,229,228,228,227,226,225,
224,223,222,221,220,219,218,216,
215,214,213,211,210,208,207,206,
205,203,202,200,199,197,195,193,
192,190,189,187,185,183,182,180,
178,176,175,173,171,169,167,165,
163,161,160,158,156,154,152,150,
148,146,144,142,140,138,136,134,
132,130,128,125,123,121,119,117,
115,113,111,109,107,105,103,101,
99,97,95,93,92,90,88,86,
84,82,80,78,77,75,73,71,
70,68,66,64,63,61,60,58,
56,54,53,51,50,49,48,46,
45,43,42,41,40,38,37,36,
35,34,33,32,31,30,29,28,
27,26,26,25,24,23,23,22,
22,21,21,20,20,19,19,18,
18,18,18,18,18,18,18,18};

unsigned char IA_RGB_blue_vec [256] = {
182,181,180,179,178,177,176,175,
174,173,172,170,169,168,167,165,
164,163,162,160,159,158,157,155,
154,152,151,149,148,147,146,144,
143,141,140,138,137,135,134,132,
131,129,128,127,126,124,123,121,
120,118,117,115,114,112,111,110,
109,107,106,104,103,101,100,99,
98,96,95,93,92,91,90,89,
88,86,85,84,83,81,80,79,
78,77,76,75,74,73,72,71,
70,69,68,67,66,65,64,63,
63,62,61,60,60,59,59,58,
57,56,56,55,55,54,54,53,
53,52,52,52,52,51,51,51,
51,50,50,50,50,50,50,50,
50,50,50,50,50,50,51,51,
51,51,51,51,52,52,53,53,
54,54,54,54,55,56,57,57,
58,58,59,59,60,61,62,62,
63,64,65,66,67,68,69,70,
71,71,72,73,75,76,77,78,
79,80,82,83,84,85,86,87,
89,90,91,92,94,95,96,97,
99,100,102,103,104,105,107,108,
110,111,113,114,116,117,118,120,
122,123,124,125,127,128,130,131,
133,134,136,137,138,139,141,142,
144,145,147,148,150,151,152,153,
155,156,158,159,161,162,163,164,
165,166,168,169,170,171,173,174,
175,176,177,178,179,180,181,182};

IA_RGB pseudocolor(u_char uc)
{
    return IA_RGB(IA_RGB_red_vec[uc],
		  IA_RGB_green_vec[uc],
		  IA_RGB_blue_vec[uc]);
}

