//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: float-conv.desc,v $
// Revision 1.3  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.2  1993/11/17  18:32:16  thoth
// forward convolutions are now supported.
// template reductions are now supported.
// minimax ring products are now supported.
//
// Revision 1.1  1993/09/15  13:02:58  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:41:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/05/26  17:16:30  thoth
// Initial revision
// 
// Revision 1.2  93/05/18  21:44:57  thoth
// New more descriptive names for standard convolutions.
// 
// Revision 1.1  93/03/18  11:23:20  thoth
// Initial revision
// 
// convolution linear_product zero=0 I(float) I(float) T(float)
IA_Image<IA_Point<int>,float> linear_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> linear_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ) {
    return linear_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution linear_product zero=0 I(float) T(float) I(float)
IA_Image<IA_Point<int>,float> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img) {
    return linear_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution addmax_product zero=-infinity() I(float) I(float) T(float)
IA_Image<IA_Point<int>,float> addmax_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> addmax_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ) {
    return addmax_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution addmax_product zero=-infinity() I(float) T(float) I(float)
IA_Image<IA_Point<int>,float> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img) {
    return addmax_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution addmin_product zero=infinity() I(float) I(float) T(float)
IA_Image<IA_Point<int>,float> addmin_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> addmin_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ) {
    return addmin_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution addmin_product zero=infinity() I(float) T(float) I(float)
IA_Image<IA_Point<int>,float> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img) {
    return addmin_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution multmax_product zero=-infinity() I(float) I(float) T(float)
IA_Image<IA_Point<int>,float> multmax_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> multmax_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ) {
    return multmax_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution multmax_product zero=-infinity() I(float) T(float) I(float)
IA_Image<IA_Point<int>,float> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img) {
    return multmax_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution multmin_product zero=infinity() I(float) I(float) T(float)
IA_Image<IA_Point<int>,float> multmin_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> multmin_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ) {
    return multmin_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution multmin_product zero=infinity() I(float) T(float) I(float)
IA_Image<IA_Point<int>,float> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,float> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img) {
    return multmin_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
//
// reduction sum zero=0 I(float) T(float)
IA_Image<IA_Point<int>,float> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,float> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction max zero=-infinity() I(float) T(float)
IA_Image<IA_Point<int>,float> max(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,float> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction min zero=infinity() I(float) T(float)
IA_Image<IA_Point<int>,float> min(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,float> > templ,
	IA_Set<IA_Point<int> > dest_domain);

