// -*- C++ -*-
//      Copyright 1993, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

#include "ia.h"
#include "List.h"

static char IA_List_c_rcsid[] = "$Id: List.c,v 1.3 1994/04/27 18:26:09 rjj Exp $";

// $Log: List.c,v $
//Revision 1.3  1994/04/27  18:26:09  rjj
//Changed T operator[](int) const  to operator().
//
//Revision 1.2  1993/11/14  19:52:13  rjj
//Changed 'emptyp()' to 'empty()'.
//
//Revision 1.1  93/11/11  01:15:59  rjj
//Initial revision
//


////////////////////////////////////////////////////////////////////////
//
//  Class  IA_List<T>
//
////////////////////////////////////////////////////////////////////////


/************************
 protected:
 ************************/

template <class T>
IA_List<T>::IA_List(const IA_Deque<T>& d) : IA_Deque<T>(d) {
}


/************************
 public:
 ************************/

template <class T>
IA_List<T>::IA_List(void)
: IA_Deque<T>() {
}


template <class T>
IA_List<T>::IA_List(const IA_List<T>& list) : IA_Deque<T>(list) {
}


template <class T>
IA_List<T>::IA_List(T *vec, unsigned size) : IA_Deque<T>(vec, size) {
}


template <class T>
IA_List<T>::IA_List(T v0) : IA_Deque<T>(v0) {
}


template <class T>
IA_List<T>::IA_List(T v0, T v1) : IA_Deque<T>(v0, v1) {
}


template <class T>
IA_List<T>::IA_List(T v0, T v1, T v2) : IA_Deque<T>(v0, v1, v2) {
}


template <class T>
IA_List<T>::IA_List(T v0, T v1, T v2, T v3) : IA_Deque<T>(v0, v1, v2, v3) {
}


template <class T>
IA_List<T>::IA_List(T v0, T v1, T v2, T v3, T v4)
: IA_Deque<T>(v0, v1, v2, v3, v4) {
}


template <class T>
int  IA_List<T>::empty() const {
    return this->IA_Deque<T>::empty();
}


template <class T>
T         IA_List<T>::head() const {
    return this->IA_Deque<T>::first();
}


template <class T>
void   IA_List<T>::tail(IA_List<T>& theTail) {

    // What kind of errors should I worry about?
    // empty list?
    if (this->empty()) {
	ia_throw(IA::INVALID_OPERATION, __FILE__, __LINE__);
	return;
    }
    if (&theTail != this) {
	theTail = *this;  // copy it over.
    }
    theTail.IA_Deque<T>::delFront();
}


template <class T>
T   IA_List<T>::operator() (unsigned index) const {

    return this->IA_Deque<T>::operator()(index);
}


template <class T>
T&  IA_List<T>::operator[] (unsigned index) {

    return this->IA_Deque<T>::operator[](index);
}
    

template <class T>
IA_List<T>&  IA_List<T>::operator= (const IA_List<T>& rhs) {

    this->IA_Deque<T>::operator=(rhs);  // Invoke for side effect...
    return *this;
}


template <class T>
void  IA_List<T>::reverse(IA_List<T>& theResult) {

    this->IA_Deque<T>::reverse(theResult);
}


template <class T>
void   IA_List<T>::sub(unsigned start_index, unsigned end_index,
		    IA_List<T>& theResult) {
    // Note, maybe end_index should be checked to be < length(),
    //       but for now it is not.
    this->IA_Deque<T>::sub(start_index, end_index, theResult);
}


template <class T>
unsigned  IA_List<T>::length() const {
    return this->IA_Deque<T>::length();
}


template <class T>
void   concat (const IA_List<T>& l1, const IA_List<T>& l2,
	       IA_List<T>& theResult) {

    concat((IA_Deque<T> &) l1,
	   (IA_Deque<T> &) l2,
	   (IA_Deque<T> &) theResult);
}


template <class T>
void  IA_List<T>::ins(T val) {

    this->IA_Deque<T>::insFront(val);
}


template <class T>
void  IA_List<T>::del() {

    if (this->empty()) {
	ia_throw(IA::INVALID_OPERATION, __FILE__, __LINE__);
    } else {
	this->IA_Deque<T>::delFront();
    }
}


template <class T>
void  IA_List<T>::delNth(unsigned index) {

    if (this->empty()) {
	ia_throw(IA::INVALID_OPERATION, __FILE__, __LINE__);
    } else {
	this->IA_Deque<T>::delNth(index);
    }
}


template <class T>
void  IA_List<T>::delValue(const T& aValueToDelete) {

    if (this->empty()) {
	ia_throw(IA::INVALID_OPERATION, __FILE__, __LINE__);
    } else {
	this->IA_Deque<T>::delValue(aValueToDelete);
    }
}




////////////////////////////////////////////////////////////////////////
//
//  Class  IA_ListIter<T>
//
////////////////////////////////////////////////////////////////////////


template <class T>
int  IA_ListIter<T>::operator() (T& receptacle) {

    return this->IA_DequeIter<T>::operator()(receptacle);
}
