// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: BaseSet.h,v $
// Revision 1.4.1.1  1994/12/08  14:41:52  thoth
// New extensive() method.
//
// Revision 1.4  1994/10/03  17:29:30  thoth
// Added support for iterators.
//
// Revision 1.3  1994/09/20  17:31:34  thoth
// Certain functions have the same answer for most derived classes so
// we might as well define them at the root.
//
// Revision 1.2  1994/04/26  18:08:17  thoth
// refcount wasn't being initialized.  Disastrous.
//
// Revision 1.1  1994/03/21  23:07:27  thoth
// Initial revision
//

#ifndef IA_BaseSet_h_
#define IA_BaseSet_h_

#include "ia.h"

template <class T>
class IA_BaseSetIter;

template <class T>
class IA_BaseSet {
    int	refcount;
public:
    IA_BaseSet() { refcount=0; }
    virtual ~IA_BaseSet() {}

    virtual IA::Type type() const=0;

    int incr_ref() { return refcount++; }
    int decr_ref() { return --refcount; }

    // if extensive() returns 1 then card(), min(), max(), empty() and
    // iterator() are guaranteed to work
    virtual int extensive() const;

    virtual unsigned card() const;

    virtual int contains (T) const = 0;

    virtual T min() const;
    virtual T max() const;
    virtual T choice() const;
    virtual int empty() const;

    virtual IA_BaseSetIter<T> *iterator() const;
};

#endif // IA_BaseSet_h_
