// template_example.02.c

//
// FloatDI magnification -- non closure version
//

#include "FloatDI.h"
#include "UcharDI.h"           // Needed for display()
#include "DDTempl.h"
#include "FloatConv.h"


const int  ident = 1;
const int  factor = 3;

IA_Image<IA_Point<int>,float> magnify(const IA_Point<int> &p)
{
    IA_Point<int>		inf_ = p*factor;
    IA_Point<int>		sup_ = (p+1)*factor - 1;

    IA_Set<IA_Point<int> >
	ps(inf_, sup(inf_,sup_));

    return IA_Image<IA_Point<int>,float>( ps, 1.0/ps.card() );
}


int main() {

    IA_Image<IA_Point<int>,float>
	im = read_int_PGM(cin);

    IA_Set<IA_Point<int> >
	ps = im.domain();

    IA_DDTemplate<IA_Image<IA_Point<int>,float> >
	mag( IA_universal_ipset(2), magnify );  // Function constructor

    IA_Set<IA_Point<int> >
	destPS( ps.inf()/factor, ps.sup()/factor );

    IA_Image<IA_Point<int>,int>
	im2 = to_int( linear_product( im, mag, destPS ));

    display(to_uchar(im));
    display(to_uchar(im2));

    return 0;
}
