// pointset_example.04.c          Float point set example

#include "DblPS.h"

int radius5disk(const IA_Point<double> &fp) {
    return fp.enorm() <= 5;
}

int main() {
    IA_Set<IA_Point<double> >
	fps1( 2,            // dim. of the points in this set
	      radius5disk); // pointer to predicate function
    			    // defining this set

    cout << fps1.contains(IA_Point<double>(0.0,0.0)) << "\n";  // true
    cout << fps1.contains(IA_Point<double>(5.0,0.0)) << "\n";  // true
    cout << fps1.contains(IA_Point<double>(5.0,1.0)) << "\n";  // false

    return 0;
}
