// image_example.03.c    Image histogram

#include "UcharDI.h"
#include "ImageIter.h"


int main() {
    IA_Image<IA_Point<int>,u_char>  inImage;

    inImage = read_uchar_PGM(cin);

    u_char  imageMin, imageMax;

    imageMin = min(inImage);
    imageMax = max(inImage);

    IA_Array<int>  histogram( imageMax - imageMin + 1 );

    for (int tmp=imageMin; tmp<=imageMax; tmp++)
	histogram[tmp] = 0;

    IA_IVIter<IA_Point<int>,u_char>
	iIter(inImage);  // Value iterator over input image

    u_char value;

    while (iIter(value)) {
	histogram[value-imageMin]++;
    }

    // Now spit out the results

    cout << "Minimum image value: " << (int) imageMin << "\n"
	 << "Maximum image value: " << (int) imageMax << "\n";

    cout << "I Val\tH Val\n";
    for (int i=imageMin; i <= imageMax; i++) {
	cout << i
	     << "\t"
	     << histogram[i]
	     << "\n";
    }

    return 0;
}
