#!/local/bin/perl

sub usage {
    print STDERR <<EOF
  Usage: $0 native-point native-type
Replaces instances of IA_Image<P,T> with IA_CoreImage<P,T> if
P!=native-point or T!=native-type.  This is necessary because CFront
does not yet allow forward declaration of template specializations and
because various IA_Image<P,T> specializations have intertwining
references.
EOF
;
    exit 1;
}

sub convert {
    local($P,$T) = @_;
    $P =~ s/\s+//g;
    $T =~ s/\s+//g;
    local ($rval);
    $rval =  ( ($P ne $point || $T ne $type) ? "IA_CoreImage" : "IA_Image" )
	. "<" . $P . ", " . $T . ">";
#    print STDERR "Checking $P=$point $T=$type: $rval\n";
    return $rval;
}


&usage if @ARGV < 2;
$point = shift;
$type = shift;

$point =~ s/\s+//g;
$type =~ s/\s+//g;

while (<>) {
# this is NOT pretty, but it's the best we can do without a real parser.
    s/IA_Image\s*<\s*(\w+(<[^>]+>|))\s*,\s*(\w+(<[^>]+>|))\s*>/&convert($1,$3)/ge;
    print;
}
