// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: OtherImageIter.c,v $
// Revision 1.1  1993/11/29  22:28:49  thoth
// Initial revision
//

#include "OtherImageIter.h"
#include "BaseI.h"

template < class P,class T>
IA_OtherIVIter<P,T>::IA_OtherIVIter(const IA_BaseImage<P,T>* img)
     :IA_BaseIVIter<P,T>(img), iter(img->domain()) { }


template < class P,class T>
IA_OtherIVIter<P,T>::IA_OtherIVIter(const IA_OtherIVIter<P,T>& iter)
     :IA_BaseIVIter<P,T>(iter.domain), iter(iter.iter) { }

template < class P,class T>
int IA_OtherIVIter<P,T>::next(T &v)
{
  P	ip;
  if (!iter(ip))
    return 0;
  v = (*domain)(ip);
  return 1;
}


template < class P,class T>
IA_OtherIPIter<P,T>::IA_OtherIPIter(const IA_BaseImage<P,T>* img)
     :IA_BaseIPIter<P,T>(img), iter(img->domain()) { }


template < class P,class T>
IA_OtherIPIter<P,T>::IA_OtherIPIter(const IA_OtherIPIter<P,T>& iter)
     :IA_BaseIPIter<P,T>(iter.domain), iter(iter.iter) { }

template < class P,class T>
int IA_OtherIPIter<P,T>::next(P &ip, T &v)
{
  if (!iter(ip))
    return 0;
  v = (*domain)(ip);
  return 1;
}
