// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: IntDDTempl.h,v $
// Revision 1.9  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.8  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.7  1994/02/22  18:48:27  thoth
// New protected constructor from BaseDT<I>*
// New constructor from base class.
//
// Revision 1.6  1994/02/12  19:37:58  thoth
// experimental pointwise ops need pointset constructors.
//
// Revision 1.5  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.4  1993/11/17  18:22:53  thoth
// sample template reduction operation is no longer needed.
//
// Revision 1.3  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.2  1993/09/27  15:51:21  thoth
// Prototype template reduction operation.
//
// Revision 1.1  93/09/15  12:54:44  thoth
// Initial revision
// 
// Revision 1.3  93/05/27  11:22:22  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/26  17:01:55  thoth
// constructors that specify pointsets aren't supported right now.
// 
// Revision 1.1  93/03/18  11:04:14  thoth
// Initial revision
// 

#ifndef IntDDTempl_h_
#define IntDDTempl_h_

#include "DDTempl.h"
#include "IntDI.h"

class IA_IntDDTemplate: public IA_DDTemplate<IA_Image<IA_Point<int>,int> > {
protected:
    IA_IntDDTemplate(IA_BaseDT<IA_Image<IA_Point<int>,int> > *t)
	:IA_DDTemplate<IA_Image<IA_Point<int>,int> >(t) { }
public:
    IA_IntDDTemplate(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > & t)
    :IA_DDTemplate<IA_Image<IA_Point<int>,int> >(t) { }
    // constructor which assumes identical dimensionality
    IA_IntDDTemplate(const IA_Image<IA_Point<int>,int> im)
    :IA_DDTemplate<IA_Image<IA_Point<int>,int> >(IA_WhiteHole(im.domain().dim()),
					im) { }
    // constructor which assumes definition over the entire space
    IA_IntDDTemplate(unsigned dim, const IA_Image<IA_Point<int>,int> im)
    :IA_DDTemplate<IA_Image<IA_Point<int>,int> >(IA_WhiteHole(dim), im) { }
    IA_IntDDTemplate(const IA_Set<IA_Point<int> > &ps, const IA_Image<IA_Point<int>,int> im)
    :IA_DDTemplate<IA_Image<IA_Point<int>,int> >(ps, im) { }

    IA_IntDDTemplate(const IA_ClosureDT< IA_Image<IA_Point<int>,int> > &o)
    :IA_DDTemplate<IA_Image<IA_Point<int>,int> >(o) { }

    IA_IntDDTemplate(unsigned dim,
		     IA_Image<IA_Point<int>,int> (*f)(const IA_Point<int>&))
    :IA_DDTemplate<IA_Image<IA_Point<int>,int> >(IA_WhiteHole(dim), f) { }
    IA_IntDDTemplate(const IA_Set<IA_Point<int> > &ps,
		     IA_Image<IA_Point<int>,int> (*f)(const IA_Point<int>&))
    :IA_DDTemplate<IA_Image<IA_Point<int>,int> >(ps, f) { }

#include	"IntConv.h"
};

#endif
