// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: ImageIter.c,v $
// Revision 1.2  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/09/15  12:54:04  thoth
// Initial revision
//

#include "ImageIter.h"

template <class P, class T>
class IA_errorIVIter: public IA_BaseIVIter<P,T> {
  public:
    IA_errorIVIter() 
    :IA_BaseIVIter<P,T>(0) {}

    virtual IA_BaseIVIter<P,T> * clone_self() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return new IA_errorIVIter;
    }

    virtual int next(T&) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return 0;
    }

    // this method resets the iterator to the beginning of the point set
    virtual void reset() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
    }

};

//
//
//

template <class P, class T>
IA_IVIter<P,T>::IA_IVIter()
{
    iter = new IA_errorIVIter<P,T>;
}

template <class P, class T>
IA_IVIter<P,T>& IA_IVIter<P,T>::operator=(const IA_CoreImage<P,T> &image)
{
    delete this->iter;

    this->iter = image.bip->value_iterator();

    return *this;
}

template <class P, class T>
IA_IVIter<P,T>& IA_IVIter<P,T>::operator=(const IA_IVIter<P,T> &x)
{
    if (x.iter==this->iter)
	return *this;

    delete this->iter;

    this->iter = x.iter->clone_self();

    return *this;
}

template <class P, class T>
class IA_errorIPIter: public IA_BaseIPIter<P,T> {
  public:
    IA_errorIPIter() 
    :IA_BaseIPIter<P,T>(0) {}

    virtual IA_BaseIPIter<P,T> * clone_self() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return new IA_errorIPIter;
    }

    virtual int next(P&, T&) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return 0;
    }

    // this method resets the iterator to the beginning of the point set
    virtual void reset() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
    }

};

//
//
//

template <class P, class T>
IA_IPIter<P,T>::IA_IPIter()
{
    iter = new IA_errorIPIter<P,T>;
}

template <class P, class T>
IA_IPIter<P,T>& IA_IPIter<P,T>::operator=(const IA_CoreImage<P,T> &image)
{
    delete this->iter;

    this->iter = image.bip->pixel_iterator();

    return *this;
}

template <class P, class T>
IA_IPIter<P,T>& IA_IPIter<P,T>::operator=(const IA_IPIter<P,T> &x)
{
    if (x.iter==this->iter)
	return *this;

    delete this->iter;

    this->iter = x.iter->clone_self();

    return *this;
}
