/* Isocontour based density Demo (version 0.0.1):
 ----------------------------------------------------
 Copyright (C) 2008 Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 
 Authors: Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 Date:    1st April 2008
 
 Contact Information:

 Ajit Rajwade:	avr@cise.ufl.edu
 Arunava Banerjee: arunava@cise.ufl.edu
 Anand Rangarajan: anand@cise.ufl.edu

 Terms:	  
 
 The source code is provided under the
 terms of the GNU General Public License (version 2).
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define LEFT 0
#define RIGHT 1
#define NL 128
#define INSIDE 1
#define OUTSIDE 0
#define INFINITY 10000
#define TOPLEFT_BOTTOMLEFT 1 
#define BOTTOMRIGHT_BOTTOMLEFT 2
#define TOPLEFT_BOTTOMRIGHT 0
#define TOPRIGHT_BOTTOMRIGHT 1
#define TOPLEFT_TOPRIGHT 2
#define EPS 10e-10
#define MAX_ARR_SIZE 1800
#define VERBOSE 0
#define VALUE_FOR_CONVERGENCE 0.1
#define START_SIGMA 10
#define MAX_ITERS_OPTIMIZATION 40
#define MAXTRIALS 20

int H,W;

/* poly.c */
double quadrilateral_Area(double *xint,double *yint);
double polyArea (double *xi, double *yi, int count);
int intersect(double *ox, double *oy,double sx, double sy, double px, double py,double startx, double starty, double endx, double endy);
int inside (double sx, double sy, double xe1, double ye1, double xe2, double ye2);
void polyClip(double *xin, double *yin, int Nin, double *xtri, double *ytri, int Ntri, double *xout, double *yout, int *Nout);
int insideTri (double xint, double yint, double i, double j, int left_right);

/* joint_density.c */
void max_min_image(double **im, double *minim, double *maxim);
void find_marginals (double *p1,double *p2,double **joint_pdf);
void joint_density_histograms (double **im1, double **im2,double **joint_pdf);
void joint_density_isocontours (double **im1, double **im2, double ** joint_pdf);
void copy_image(double **dest, double **src);
void image_warp_2d_linear_interp (double **dest, double **src, double R[][2]);
void create_matrix (double R[][2], double angle);
void write_image (double **im, char *filename);
void write_poly (double *xint,double *yint,int count);
void copy (double *dest, double *src, int N);
void swap (double *a, double *b);
double bilinear_interp(double **im, double j, double i);
double min3 (double a, double b, double c);
double max3 (double a, double b, double c);
double** createPairs(int *numPairs, double i1_1, double i1_2, double i1_3, double i2_1, double i2_2, double i2_3);
double bilinear_interpolant (double **src, double x, double y);
double **allocate_2d_double(int N,int M,char zero);
void free_2d_double(double **a,int N);
double *allocate_1d_double(int N,char zero);

/* isbi.c */
void joint_pdf_isbi (double **im1, double **im2, double ** joint_pdf);
