/* Isocontour based density Demo (version 0.0.1):
 ----------------------------------------------------
 Copyright (C) 2008 Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 
 Authors: Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 Date:    1st April 2008
 
 Contact Information:

 Ajit Rajwade:	avr@cise.ufl.edu
 Arunava Banerjee: arunava@cise.ufl.edu
 Anand Rangarajan:	anand@cise.ufl.edu

 Terms:	  
 
 The source code is provided under the
 terms of the GNU General Public License (version 2).
*/

#include "regim.h"

double total_area = 0;

void copy (double *dest, double *floating_image, int N)
{
	int i;

	for(i=0;i<N;i++)
	{
		dest[i] = floating_image[i];
	}
}

void swap (double *a, double *b)
{
	double temp;

	temp = *a; *a = *b; *b = temp;
}


double bilinear_interp(double **im, double j, double i)
{
	return (im[(int)(i+0.5)][(int)(j+0.5)]+im[(int)(i+0.5)][(int)(j-0.5)]+im[(int)(i-0.5)][(int)(j-0.5)]+im[(int)(i-0.5)][(int)(j+0.5)])/4;
}

double min3 (double a, double b, double c)
{
	if (a <= b && a <= c) return a; 
	if (b <= a && b <= c) return b; 
	if (c <= a && c <= b) return c; 
}

double max3 (double a, double b, double c)
{
	if (a >= b && a >= c) return a; 
	if (b >= a && b >= c) return b; 
	if (c >= a && c >= b) return c; 
}

double** createPairs(int *numPairs, double i1_1, double i1_2, double i1_3, double i2_1, double i2_2, double i2_3)
{
	double max1,max2,min1,min2;
	double i,j;
	int count = 0;
	double **pairs;
	double A,B;

	min1 = (min3(i1_1, i1_2, i1_3));
	max1 = (max3(i1_1, i1_2, i1_3));
	min2 = (min3(i2_1, i2_2, i2_3));
	max2 = (max3(i2_1, i2_2, i2_3));

	if (min1 < 0 || min2 < 0) 
	{ 
		*numPairs = 0; 
		return NULL; 
	}

	A = max1-min1; if (A==0) A = 1;
	B = max2-min2; if (B==0) B = 1;
	*numPairs = (int)(A*B);
	pairs = allocate_2d_double (*numPairs,2,'1');

	for (j=min2;j<min2+B;j=j+1)
	{
		for(i=min1;i<min1+A;i=i+1)
		{
			pairs[count][0] = i; pairs[count][1] = j;
			count = count + 1;
		}
	}

	*numPairs = count;

	return pairs;
}


void createPairs2 (double pairs[NL*NL][2],int *numPairs, double i1_1, double i1_2, double i1_3, double i2_1, double i2_2, double i2_3)
{
	double max1,max2,min1,min2;
	double i,j;
	int count = 0;
	double A,B;

	min1 = (min3(i1_1, i1_2, i1_3));
	max1 = (max3(i1_1, i1_2, i1_3));
	min2 = (min3(i2_1, i2_2, i2_3));
	max2 = (max3(i2_1, i2_2, i2_3));

	if (min1 < 0 || min2 < 0) 
	{ 
		*numPairs = 0; 
		return; 
	}

	A = max1-min1; if (A==0) A = 1;
	B = max2-min2; if (B==0) B = 1;
	*numPairs = (int)(A*B);

	for (j=min2;j<min2+B;j=j+1)
	{
		for(i=min1;i<min1+A;i=i+1)
		{
			pairs[count][0] = i; pairs[count][1] = j;
			count = count + 1;
		}
	}

	*numPairs = count;

	return;
}


void joint_density_isocontours (double **im1, double **im2, double ** joint_pdf)
{
	int i,j,k,kk,ll;
	int f1,f2,f3,f4,f,fl,tempflags[10],tempflags1[10],tempflags2[10];	
	double i1_topleft, i1_topright, i1_bottomleft, i1_bottomright;
	double i2_topleft, i2_topright, i2_bottomleft, i2_bottomright;
	double pairs[NL*NL][2];
	int numpairs,Nout;
	double x1,x2,x3,y1,y2,y3,xint[10],yint[10],xtri[10],ytri[10],xout[10],yout[10],xint_1[10],yint_1[10],xint_2[10],yint_2[10];
	double xint1,yint1,xint2,yint2,xint3,yint3,xint4,yint4;
	double deter,d1,d2;
	double invMat[3][3];
	double a11,b11,c11,a12,b12,c12,a22,b22,c22,a21,b21,c21;
	int ind1,ind2,count,count_1,count_2,nflag;
	double minim1,minim2,maxim1,maxim2,sum,area,pix_area1,pix_area2;
	double extra_x,extra_y;


	for(i=0;i<10;i++)
	{
		xout[i] = 0;
		yout[i] = 0;
	}

	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			joint_pdf[i][j] = 0;
		}
	}

	max_min_image(im1,&minim1,&maxim1);
	max_min_image(im2,&minim2,&maxim2);

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			im1[i][j] = floor((NL-1)*(im1[i][j]-minim1)/(maxim1-minim1)); /*im1[i][j] /= (256/NL);*/
			im2[i][j] = floor((NL-1)*(im2[i][j]-minim2)/(maxim2-minim2)); /*im2[i][j] /= (256/NL);*/
		}
	}

	for (i=0;i<H-1;i++)
	{
		for(j=0;j<W-1;j++)
		{
			if (VERBOSE == 1)
			{
				printf ("\n%d %d",i,j); fflush(stdout);
			}

			/*i1_topleft = floor(bilinear_interp(im1,j-0.5,i-0.5));
			i2_topleft = floor(bilinear_interp(im2,j-0.5,i-0.5));

			i1_topright = floor(bilinear_interp(im1,j+0.5,i-0.5));
			i2_topright = floor(bilinear_interp(im2,j+0.5,i-0.5));

			i1_bottomleft = floor(bilinear_interp(im1,j-0.5,i+0.5));
			i2_bottomleft = floor(bilinear_interp(im2,j-0.5,i+0.5));

			i1_bottomright = floor(bilinear_interp(im1,j+0.5,i+0.5));
			i2_bottomright = floor(bilinear_interp(im2,j+0.5,i+0.5));*/


/*	 		if(i==17 && j == 74)
			{
				i = 13;
			}else continue;
*/

			pix_area1 = 0; pix_area2 = 0; nflag = 0;

			i1_topleft = im1[i][j]; i1_topright = im1[i][j+1]; i1_bottomleft = im1[i+1][j]; i1_bottomright = im1[i+1][j+1];
			i2_topleft = im2[i][j]; i2_topright = im2[i][j+1]; i2_bottomleft = im2[i+1][j]; i2_bottomright = im2[i+1][j+1];	
							
			/* left half-pixel: TL, BL, BR  - create the intensity pairs */
			createPairs2 (pairs, &numpairs,i1_topleft,i1_bottomleft,i1_bottomright,i2_topleft,i2_bottomleft,i2_bottomright);
	
			if (numpairs <= 0) { nflag++; goto upper_pixel;}

			/* topleft: [x1,y1] = [j-0.5,i-0.5];; bottomleft: [x2,y2] = [j-0.5,i+0.5];; bottomright: [x3,y3] = [j+0.5,i+0.5] */
			x1 = x2 = j; y1 = i; y2 = y3 = i+1; x3 = j+1;
			xtri[0] = x1; xtri[1] = x2; xtri[2] = x3;
			ytri[0] = y1; ytri[1] = y2; ytri[2] = y3;

			deter = x1*(y2-y3)+x2*(y3-y1)+x3*(y1-y2);
			invMat[0][0] = (y2-y3)/deter;
			invMat[0][1] = (x3-x2)/deter;
			invMat[0][2] = (x2*y3-y2*x3)/deter;
			invMat[1][0] = (y3-y1)/deter;
			invMat[1][1] = (x1-x3)/deter;
			invMat[1][2] = (x3*y1-x1*y3)/deter;
			invMat[2][0] = (y1-y2)/deter;
			invMat[2][1] = (x2-x1)/deter;
			invMat[2][2] = (x1*y2-y1*x2)/deter;
		
			/* coefficients of the plane for image 1 */
			a11 = i1_topleft*invMat[0][0]+i1_bottomleft*invMat[1][0] + i1_bottomright*invMat[2][0];
			b11 = i1_topleft*invMat[0][1]+i1_bottomleft*invMat[1][1] + i1_bottomright*invMat[2][1];
			c11 = i1_topleft*invMat[0][2]+i1_bottomleft*invMat[1][2] + i1_bottomright*invMat[2][2];

			/* coefficients of the plane for image 2 */
			a12 = i2_topleft*invMat[0][0]+i2_bottomleft*invMat[1][0] + i2_bottomright*invMat[2][0];
			b12 = i2_topleft*invMat[0][1]+i2_bottomleft*invMat[1][1] + i2_bottomright*invMat[2][1];
			c12 = i2_topleft*invMat[0][2]+i2_bottomleft*invMat[1][2] + i2_bottomright*invMat[2][2];

			d1 = a11*b12-b11*a12;

			/* both images flat */
			if (a11 == 0 && b11 == 0 && a12 == 0 && b12 == 0)
			{
				ind1 = pairs[0][0]; ind2 = pairs[0][1]; pix_area1 += 0.5; total_area += 0.5;
				joint_pdf[ind1][ind2] += 0.5;
			}
			/* image 1 flat and image 2 is not flat */
			else if (a11 == 0 && b11 == 0)
			{
				ind1 = pairs[0][0];

				if (b12 == 0) // image 2 is vertically flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind2 = pairs[k][1];

						count = 0;
						if ((ind2 >= i2_bottomright && ind2 <= i2_bottomleft) || (ind2 <= i2_bottomright && ind2 >= i2_bottomleft))
						{
							yint[count] = y2; 
							xint[count++] = x2+(ind2-i2_bottomleft)/(i2_bottomright-i2_bottomleft);
						}
						if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
						{
							xint[count] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
						}

						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
						{
							xint[count] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
						}
						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_bottomleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_bottomleft))
						{
							yint[count] = y2; 
							xint[count++] = x2+(ind2+1-i2_bottomleft)/(i2_bottomright-i2_bottomleft);
						}
					
						area = polyArea(xint,yint,count); total_area += area; pix_area1 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else if (a12 == 0) // image 2 is horizontally flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind2 = pairs[k][1];

						count = 0;
						if ((ind2 >= i2_topleft && ind2 <= i2_bottomleft) || (ind2 <= i2_topleft && ind2 >= i2_bottomleft))
						{
							xint[count] = x1; 
							yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomleft-i2_topleft);
						}
						if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
						{
							xint[count] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
						}
						
						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
						{
							xint[count] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
						}
						if ((ind2+1 >= i2_topleft && ind2+1 <= i2_bottomleft) || (ind2+1 <= i2_topleft && ind2+1 >= i2_bottomleft))
						{
							xint[count] = x1; 
							yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomleft-i2_topleft);
						}
					
						area = polyArea(xint,yint,count); total_area += area;pix_area1 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else // image 2 is neither vertically nor horizontally flat
				{
					for(k=0;k<numpairs;k++)	
					{
						ind1 = pairs[k][0]; ind2 = pairs[k][1];
						tempflags[0] = tempflags[1] = tempflags[2] = 0;

						count = 0; fl = 0;					
						if (b12 != 0)
						{
							if ((ind2 >= i2_topleft && ind2 <= i2_bottomleft) || (ind2 <= i2_topleft && ind2 >= i2_bottomleft))
							{
								tempflags[TOPLEFT_BOTTOMLEFT]++;
								xint[count] = x1; yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomleft-i2_topleft);
								fl++;	
							}

							if ((ind2+1 >= i2_topleft && ind2+1 <= i2_bottomleft) || (ind2+1 <= i2_topleft && ind2+1 >= i2_bottomleft))
							{
								tempflags[TOPLEFT_BOTTOMLEFT]++;
								xint[count] = x1; yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomleft-i2_topleft);	
								fl++;
							}

							if (fl == 2 && yint[count-1] < yint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						fl = 0;
						if (a12 != 0)
						{
							if ((ind2 >= i2_bottomright && ind2 <= i2_bottomleft) || (ind2 <= i2_bottomright && ind2 >= i2_bottomleft))
							{
								tempflags[BOTTOMRIGHT_BOTTOMLEFT]++;
								yint[count] = y2; xint[count++] = x2+(ind2-i2_bottomleft)/(i2_bottomright-i2_bottomleft);
								fl++;
							}

							if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_bottomleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_bottomleft))
							{
								tempflags[BOTTOMRIGHT_BOTTOMLEFT]++;
								yint[count] = y2; xint[count++] = x2+(ind2+1-i2_bottomleft)/(i2_bottomright-i2_bottomleft);
								fl++;
							}

							if (fl == 2 && xint[count-1] < xint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						fl = 0;
						if (i2_topleft != i2_bottomright)
						{
							if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
								yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
								fl++;
							}

							if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
								yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
								fl++;
							}

							if (fl==2 && xint[count-1] > xint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						if (tempflags[TOPLEFT_BOTTOMLEFT] == 1 && tempflags[BOTTOMRIGHT_BOTTOMLEFT] == 1)
						{
							extra_x = j; extra_y = i+1;
							for(ll=tempflags[TOPLEFT_BOTTOMLEFT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags[BOTTOMRIGHT_BOTTOMLEFT] == 1)
						{
							extra_x = j+1; extra_y = i+1;
							for(ll=tempflags[TOPLEFT_BOTTOMLEFT]+tempflags[BOTTOMRIGHT_BOTTOMLEFT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags[TOPLEFT_BOTTOMLEFT] == 1)
						{
							xint[count] = j; yint[count++] = i;
						}

						area = polyArea(xint,yint,count); total_area += area;pix_area1 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
			}
			/***********************************************/
			/* image 2 is flat and image 1 is not flat */
			else if (a12 == 0 && b12 == 0)
			{
				ind2 = pairs[0][1];

				if (b11 == 0) // image 1 is vertically flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind1 = pairs[k][0];

						count = 0;
						if ((ind1 >= i1_bottomright && ind1 <= i1_bottomleft) || (ind1 <= i1_bottomright && ind1 >= i1_bottomleft))
						{
							yint[count] = y2; 
							xint[count++] = x2+(ind1-i1_bottomleft)/(i1_bottomright-i1_bottomleft);
						}
						if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
						{
							xint[count] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						
						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
						{
							xint[count] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_bottomleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_bottomleft))
						{
							yint[count] = y2; 
							xint[count++] = x2+(ind1+1-i1_bottomleft)/(i1_bottomright-i1_bottomleft);
						}
					
						area = polyArea(xint,yint,count); total_area += area;pix_area1 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else if (a11 == 0) // image 1 is horizontally flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind1 = pairs[k][0];

						count = 0;
						if ((ind1 >= i1_topleft && ind1 <= i1_bottomleft) || (ind1 <= i1_topleft && ind1 >= i1_bottomleft))
						{
							xint[count] = x1; 
							yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomleft-i1_topleft);
						}
						if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
						{
							xint[count] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						

						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
						{
							xint[count] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						if ((ind1+1 >= i1_topleft && ind1+1 <= i1_bottomleft) || (ind1+1 <= i1_topleft && ind1+1 >= i1_bottomleft))
						{
							xint[count] = x1; 
							yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomleft-i1_topleft);
						}
					
						area = polyArea(xint,yint,count); total_area += area;pix_area1 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else // image 1 is neither vertically nor horizontally flat
				{
					for(k=0;k<numpairs;k++)	
					{
						ind1 = pairs[k][0];	
						tempflags[0] = tempflags[1] = tempflags[2] = 0;

						count = 0; fl = 0;					
						if (b11 != 0)
						{
							if ((ind1 >= i1_topleft && ind1 <= i1_bottomleft) || (ind1 <= i1_topleft && ind1 >= i1_bottomleft))
							{
								tempflags[TOPLEFT_BOTTOMLEFT]++;
								xint[count] = x1; yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomleft-i1_topleft);	
								fl++;
							}

							if ((ind1+1 >= i1_topleft && ind1+1 <= i1_bottomleft) || (ind1+1 <= i1_topleft && ind1+1 >= i1_bottomleft))
							{
								tempflags[TOPLEFT_BOTTOMLEFT]++;
								xint[count] = x1; yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomleft-i1_topleft);
								fl++;	
							}

							if (fl == 2 && yint[count-1] < yint[count-2])
							{
								swap(&xint[count-1],&xint[count-2]);
								swap(&yint[count-1],&yint[count-2]);
							}
						}

						fl = 0;
						if (a11 != 0)
						{
							if ((ind1 >= i1_bottomright && ind1 <= i1_bottomleft) || (ind1 <= i1_bottomright && ind1 >= i1_bottomleft))
							{
								tempflags[BOTTOMRIGHT_BOTTOMLEFT]++;
								yint[count] = y2; xint[count++] = x2+(ind1-i1_bottomleft)/(i1_bottomright-i1_bottomleft);
								fl++;
							}

							if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_bottomleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_bottomleft))
							{
								tempflags[BOTTOMRIGHT_BOTTOMLEFT]++;
								yint[count] = y2; xint[count++] = x2+(ind1+1-i1_bottomleft)/(i1_bottomright-i1_bottomleft);
								fl++;
							}

							if (fl == 2 && xint[count-1] < xint[count-2])
							{
								swap(&xint[count-1],&xint[count-2]);
								swap(&yint[count-1],&yint[count-2]);
							}
						}


						fl = 0;
						if (i1_topleft != i1_bottomright)
						{
							if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
								yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
								fl++;
							}

							if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
								yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
								fl++;
							}

							if (fl==2 && xint[count-1] > xint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						if (tempflags[TOPLEFT_BOTTOMLEFT] == 1 && tempflags[BOTTOMRIGHT_BOTTOMLEFT] == 1)
						{
							extra_x = j; extra_y = i+1;
							for(ll=tempflags[TOPLEFT_BOTTOMLEFT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags[BOTTOMRIGHT_BOTTOMLEFT] == 1)
						{
							extra_x = j+1; extra_y = i+1;
							for(ll=tempflags[TOPLEFT_BOTTOMLEFT]+tempflags[BOTTOMRIGHT_BOTTOMLEFT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags[TOPLEFT_BOTTOMLEFT] == 1)
						{
							xint[count] = j; yint[count++] = i;
						}

						area = polyArea(xint,yint,count); total_area += area;pix_area1 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
			}// close else if
			/***********************************************/
			/* neither of the two images is flat but gradients from the two images are parallel or coincident */
			else if (d1 == 0)
			{
				for(k=0;k<numpairs;k++)	
				{
					ind1 = pairs[k][0]; ind2 = pairs[k][1];	
					tempflags1[0] = tempflags1[1] = tempflags1[2] = 0;
					tempflags2[0] = tempflags2[1] = tempflags2[2] = 0;

					count_1 = 0; fl = 0;					
					if (b11 != 0)
					{
						if ((ind1 >= i1_topleft && ind1 <= i1_bottomleft) || (ind1 <= i1_topleft && ind1 >= i1_bottomleft))
						{
							tempflags1[TOPLEFT_BOTTOMLEFT]++;
							xint_1[count_1] = x1; yint_1[count_1++] = y1+(ind1-i1_topleft)/(i1_bottomleft-i1_topleft);	
							fl++;
						}
						if ((ind1+1 >= i1_topleft && ind1+1 <= i1_bottomleft) || (ind1+1 <= i1_topleft && ind1+1 >= i1_bottomleft))
						{
							tempflags1[TOPLEFT_BOTTOMLEFT]++;
							xint_1[count_1] = x1; yint_1[count_1++] = y1+(ind1+1-i1_topleft)/(i1_bottomleft-i1_topleft);	
							fl++;
						}

						if (fl == 2 && yint_1[count_1-1] < yint_1[count_1-2])
						{
							swap(&yint_1[count_1-1],&yint_1[count_1-2]);
							swap(&xint_1[count_1-1],&xint_1[count_1-2]);
						}
					}


					fl = 0;
					if (a11 != 0)
					{
						if ((ind1 >= i1_bottomright && ind1 <= i1_bottomleft) || (ind1 <= i1_bottomright && ind1 >= i1_bottomleft))
						{
							tempflags1[BOTTOMRIGHT_BOTTOMLEFT]++;
							yint_1[count_1] = y2; xint_1[count_1++] = x2+(ind1-i1_bottomleft)/(i1_bottomright-i1_bottomleft);
							fl++;
						}
						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_bottomleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_bottomleft))
						{
							tempflags1[BOTTOMRIGHT_BOTTOMLEFT]++;
							yint_1[count_1] = y2; xint_1[count_1++] = x2+(ind1+1-i1_bottomleft)/(i1_bottomright-i1_bottomleft);
							fl++;
						}
						if (fl == 2 && xint_1[count_1-1] < xint_1[count_1-2])
						{
							swap(&yint_1[count_1-1],&yint_1[count_1-2]);
							swap(&xint_1[count_1-1],&xint_1[count_1-2]);
						}
					}

					fl = 0;
					if (i1_topleft != i1_bottomright)
					{
						if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
						{
							tempflags1[TOPLEFT_BOTTOMRIGHT]++;
							xint_1[count_1] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint_1[count_1++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							fl++;
						}
						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
						{
							tempflags1[TOPLEFT_BOTTOMRIGHT]++;
							xint_1[count_1] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint_1[count_1++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							fl++;
						}
						if (fl == 2 && yint_1[count_1-1] > yint_1[count_1-2])
						{
							swap(&yint_1[count_1-1],&yint_1[count_1-2]);
							swap(&xint_1[count_1-1],&xint_1[count_1-2]);
						}
					}

					if (tempflags1[TOPLEFT_BOTTOMLEFT] == 1 && tempflags1[BOTTOMRIGHT_BOTTOMLEFT] == 1)
					{
						extra_x = j; extra_y = i+1;
						for(ll=tempflags1[TOPLEFT_BOTTOMLEFT]; ll<count_1;ll++)
						{
							swap(&extra_x,&xint_1[ll]); swap(&extra_y,&yint_1[ll]);
						}
						xint_1[count_1] = extra_x; yint_1[count_1++] = extra_y;
					}
					else if (tempflags1[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags1[BOTTOMRIGHT_BOTTOMLEFT] == 1)
					{
						extra_x = j+1; extra_y = i+1;
						for(ll=tempflags1[TOPLEFT_BOTTOMLEFT]+tempflags1[BOTTOMRIGHT_BOTTOMLEFT]; ll<count_1;ll++)
						{
							swap(&extra_x,&xint_1[ll]); swap(&extra_y,&yint_1[ll]);
						}
						xint_1[count_1] = extra_x; yint_1[count_1++] = extra_y;
					}
					else if (tempflags1[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags1[TOPLEFT_BOTTOMLEFT] == 1)
					{
						xint_1[count_1] = j; yint_1[count_1++] = i;
					}

					count_2 = 0; fl = 0;					
					if (b12 != 0)
					{
						if ((ind2 >= i2_topleft && ind2 <= i2_bottomleft) || (ind2 <= i2_topleft && ind2 >= i2_bottomleft))
						{
							tempflags2[TOPLEFT_BOTTOMLEFT]++;
							xint_2[count_2] = x1; yint_2[count_2++] = y1+(ind2-i2_topleft)/(i2_bottomleft-i2_topleft);	
							fl++;
						}
						if ((ind2+1 >= i2_topleft && ind2+1 <= i2_bottomleft) || (ind2+1 <= i2_topleft && ind2+1 >= i2_bottomleft))
						{
							tempflags2[TOPLEFT_BOTTOMLEFT]++;
							xint_2[count_2] = x1; yint_2[count_2++] = y1+(ind2+1-i2_topleft)/(i2_bottomleft-i2_topleft);	
							fl++;
						}

						if (fl == 2 && yint_2[count_2-1] < yint_2[count_2-2])
						{
							swap(&yint_2[count_2-1],&yint_2[count_2-2]);
							swap(&xint_2[count_2-1],&xint_2[count_2-2]);
						}
					}

					fl = 0;
					if (a12 != 0)
					{
						if ((ind2 >= i2_bottomright && ind2 <= i2_bottomleft) || (ind2 <= i2_bottomright && ind2 >= i2_bottomleft))
						{
							tempflags2[BOTTOMRIGHT_BOTTOMLEFT]++;
							yint_2[count_2] = y2; xint_2[count_2++] = x2+(ind2-i2_bottomleft)/(i2_bottomright-i2_bottomleft);
							fl++;
						}
						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_bottomleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_bottomleft))
						{
							tempflags2[BOTTOMRIGHT_BOTTOMLEFT]++;
							yint_2[count_2] = y2; xint_2[count_2++] = x2+(ind2+1-i2_bottomleft)/(i2_bottomright-i2_bottomleft);
							fl++;
						}
						if (fl == 2 && xint_2[count_2-1] < xint_2[count_2-2])
						{
							swap(&yint_2[count_2-1],&yint_2[count_2-2]);
							swap(&xint_2[count_2-1],&xint_2[count_2-2]);
						}
					}

					fl = 0;
					if (i2_topleft != i2_bottomright)
					{
						if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
						{
							tempflags2[TOPLEFT_BOTTOMRIGHT]++;
							xint_2[count_2] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							yint_2[count_2++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							fl++;
						}
						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
						{
							tempflags2[TOPLEFT_BOTTOMRIGHT]++;
							xint_2[count_2] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							yint_2[count_2++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							fl++;
						}
						if (fl == 2 && yint_2[count_2-1] > yint_2[count_2-2])
						{
							swap(&yint_2[count_2-1],&yint_2[count_2-2]);
							swap(&xint_2[count_2-1],&xint_2[count_2-2]);
						}
					}

					if (tempflags2[TOPLEFT_BOTTOMLEFT] == 1 && tempflags2[BOTTOMRIGHT_BOTTOMLEFT] == 1)
					{
						extra_x = j; extra_y = i+1;
						for(ll=tempflags2[TOPLEFT_BOTTOMLEFT]; ll<count_2;ll++)
						{
							swap(&extra_x,&xint_2[ll]); swap(&extra_y,&yint_2[ll]);
						}
						xint_2[count_2] = extra_x; yint_2[count_2++] = extra_y;
					}
					else if (tempflags2[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags2[BOTTOMRIGHT_BOTTOMLEFT] == 1)
					{
						extra_x = j+1; extra_y = i+1;
						for(ll=tempflags2[TOPLEFT_BOTTOMLEFT]+tempflags2[BOTTOMRIGHT_BOTTOMLEFT]; ll<count_2;ll++)
						{
							swap(&extra_x,&xint_2[ll]); swap(&extra_y,&yint_2[ll]);
						}
						xint_2[count_2] = extra_x; yint_2[count_2++] = extra_y;
					}
					else if (tempflags2[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags2[TOPLEFT_BOTTOMLEFT] == 1)
					{
						xint_2[count_2] = j; yint_2[count_2++] = i;
					}


					polyClip(xint_1,yint_1,count_1,xint_2,yint_2,count_2,xout,yout,&Nout);
					area = polyArea(xout,yout,Nout); total_area += area;pix_area1 += area;
					joint_pdf[ind1][ind2] += area;
					write_poly (xout,yout,Nout);
				}
			}// close else if
			/* neither of the pathological cases! */
			else
			{
				for(k=0;k<numpairs;k++)	
				{
					ind1 = pairs[k][0];
					ind2 = pairs[k][1];

					xint1 = (b12*(ind1-c11)-b11*(ind2-c12))/d1;
					yint1 = (-a12*(ind1-c11)+a11*(ind2-c12))/d1;

					xint2 = (b12*(ind1-c11+1)-b11*(ind2-c12))/d1;
					yint2 = (-a12*(ind1-c11+1)+a11*(ind2-c12))/d1;

					xint4 = (b12*(ind1-c11)-b11*(ind2-c12+1))/d1;
					yint4 = (-a12*(ind1-c11)+a11*(ind2-c12+1))/d1;

					xint3 = (b12*(ind1-c11+1)-b11*(ind2-c12+1))/d1;
					yint3 = (-a12*(ind1-c11+1)+a11*(ind2-c12+1))/d1;

					f1 = insideTri(xint1,yint1,(double)i,(double)j,LEFT);
					f2 = insideTri(xint2,yint2,(double)i,(double)j,LEFT);
					f3 = insideTri(xint3,yint3,(double)i,(double)j,LEFT);
					f4 = insideTri(xint4,yint4,(double)i,(double)j,LEFT);
					f = f1+f2+f3+f4;

					xint[0] = xint1; xint[1] = xint2; xint[2] = xint3; xint[3] = xint4;
					yint[0] = yint1; yint[1] = yint2; yint[2] = yint3; yint[3] = yint4;

					if (f == 4)
					{
						area = polyArea(xint,yint,4); total_area += area;pix_area1 += area;
						joint_pdf[ind1][ind2] += area; 
						write_poly (xint,yint,4);
					}
					else
					{
						polyClip(xint,yint,4,xtri,ytri,3,xout,yout,&Nout);
						area = polyArea(xout,yout,Nout); total_area += area;pix_area1 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xout,yout,Nout);
					}				
				}
			}//close else

			//if (numpairs > 0) free_2d_double(pairs,numpairs);
			/************************************************************************************************************************/
			/* now deal with the upper half pixel, i.e. topleft to topright, topright to bottom right, topleft to bottomright */

upper_pixel:
			/* left half-pixel: TL, BL, BR  - create the intensity pairs */
			createPairs2 (pairs,&numpairs,i1_topleft,i1_topright, i1_bottomright, i2_topleft, i2_topright, i2_bottomright);

			if (numpairs <= 0) { nflag++; goto end_pixel;}

			/* topleft: [x1,y1] = [j-0.5,i-0.5];; topright: [x2,y2] = [j+0.5,i-0.5];; bottomright: [x3,y3] = [j+0.5,i+0.5] */
			x1 = j; y1 = y2 = i; y3 = i+1; x2 = x3 = j+1;
			xtri[0] = x1; xtri[1] = x3; xtri[2] = x2;
			ytri[0] = y1; ytri[1] = y3; ytri[2] = y2;

			deter = x1*(y2-y3)+x2*(y3-y1)+x3*(y1-y2);
			invMat[0][0] = (y2-y3)/deter;
			invMat[0][1] = (x3-x2)/deter;
			invMat[0][2] = (x2*y3-y2*x3)/deter;
			invMat[1][0] = (y3-y1)/deter;
			invMat[1][1] = (x1-x3)/deter;
			invMat[1][2] = (x3*y1-x1*y3)/deter;
			invMat[2][0] = (y1-y2)/deter;
			invMat[2][1] = (x2-x1)/deter;
			invMat[2][2] = (x1*y2-y1*x2)/deter;
		
			/* coefficients of the plane for image 1 */
			a21 = i1_topleft*invMat[0][0]+i1_topright*invMat[1][0] + i1_bottomright*invMat[2][0];
			b21 = i1_topleft*invMat[0][1]+i1_topright*invMat[1][1] + i1_bottomright*invMat[2][1];
			c21 = i1_topleft*invMat[0][2]+i1_topright*invMat[1][2] + i1_bottomright*invMat[2][2];

			/* coefficients of the plane for image 2 */
			a22 = i2_topleft*invMat[0][0]+i2_topright*invMat[1][0] + i2_bottomright*invMat[2][0];
			b22 = i2_topleft*invMat[0][1]+i2_topright*invMat[1][1] + i2_bottomright*invMat[2][1];
			c22 = i2_topleft*invMat[0][2]+i2_topright*invMat[1][2] + i2_bottomright*invMat[2][2];

			d2 = a21*b22-b21*a22;

			/* both images flat */
			if (a21 == 0 && b21 == 0 && a22 == 0 && b22 == 0)
			{
				ind1 = pairs[0][0]; ind2 = pairs[0][1];
				joint_pdf[ind1][ind2] += 0.5; pix_area2 += 0.5; total_area += 0.5;
			}
			/* image 1 flat and image 2 is not flat */
			else if (a21 == 0 && b21 == 0)
			{
				ind1 = pairs[0][0];
	
				if (b22 == 0) // image 2 is vertically flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind2 = pairs[k][1];
						count = 0;
						if ((ind2 >= i2_topright && ind2 <= i2_topleft) || (ind2 <= i2_topright && ind2 >= i2_topleft))
						{
							yint[count] = y1; 
							xint[count++] = x1+(ind2-i2_topleft)/(i2_topright-i2_topleft);
						}
						if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
						{
							xint[count] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
						}
	
						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
						{
							xint[count] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
						}
						if ((ind2+1 >= i2_topright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_topright && ind2+1 >= i2_topleft))
						{
							yint[count] = y1; 
							xint[count++] = x1+(ind2+1-i2_topleft)/(i2_topright-i2_topleft);
						}
						
						area = polyArea(xint,yint,count); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else if (a22 == 0) // image 2 is horizontally flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind2 = pairs[k][1];
						count = 0;
						if ((ind2 >= i2_topright && ind2 <= i2_bottomright) || (ind2 <= i2_topright && ind2 >= i2_bottomright))
						{
							xint[count] = x2; 
							yint[count++] = y2+(ind2-i2_topright)/(i2_bottomright-i2_topright);
						}
						if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
						{
							xint[count] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
						}
						
						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
						{
							xint[count] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
						}
						if ((ind2+1 >= i2_topright && ind2+1 <= i2_bottomright) || (ind2+1 <= i2_topright && ind2+1 >= i2_bottomright))
						{
							xint[count] = x2; 
							yint[count++] = y2+(ind2+1-i2_topright)/(i2_bottomright-i2_topright);
						}
					
						area = polyArea(xint,yint,count); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else // image 2 is neither vertically nor horizontally flat
				{
					for(k=0;k<numpairs;k++)	
					{
						ind1 = pairs[k][0]; ind2 = pairs[k][1];
						tempflags[0] = tempflags[1] = tempflags[2] = tempflags[3] = tempflags[4] = 0;
	
						count = 0; fl = 0;					
						if (b22 != 0)
						{
							if ((ind2 >= i2_topright && ind2 <= i2_bottomright) || (ind2 <= i2_topright && ind2 >= i2_bottomright))
							{
								tempflags[TOPRIGHT_BOTTOMRIGHT]++;
								xint[count] = x2; yint[count++] = y2+(ind2-i2_topright)/(i2_bottomright-i2_topright);
								fl++;	
							}

							if ((ind2+1 >= i2_topright && ind2+1 <= i2_bottomright) || (ind2+1 <= i2_topright && ind2+1 >= i2_bottomright))
							{
								tempflags[TOPRIGHT_BOTTOMRIGHT]++;
								xint[count] = x2; yint[count++] = y2+(ind2+1-i2_topright)/(i2_bottomright-i2_topright);	
								fl++;
							}

							if (fl == 2 && yint[count-1] > yint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						fl = 0;
						if (a22 != 0)
						{
							if ((ind2 >= i2_topright && ind2 <= i2_topleft) || (ind2 <= i2_topright && ind2 >= i2_topleft))
							{
								tempflags[TOPLEFT_TOPRIGHT]++;
								yint[count] = y1; xint[count++] = x1+(ind2-i2_topleft)/(i2_topright-i2_topleft);
								fl++;
							}

							if ((ind2+1 >= i2_topright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_topright && ind2+1 >= i2_topleft))
							{
								tempflags[TOPLEFT_TOPRIGHT]++;
								yint[count] = y1; xint[count++] = x1+(ind2+1-i2_topleft)/(i2_topright-i2_topleft);
								fl++;
							}

							if (fl == 2 && xint[count-1] > xint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						fl = 0;
						if (i2_topleft != i2_bottomright)
						{
							if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
								yint[count++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
								fl++;
							}

							if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
								yint[count++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
								fl++;
							}

							if (fl == 2 && yint[count-1] < yint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						if (tempflags[TOPLEFT_TOPRIGHT] == 1 && tempflags[TOPRIGHT_BOTTOMRIGHT] == 1)
						{
							extra_x = j+1; extra_y = i;
							for(ll=tempflags[TOPRIGHT_BOTTOMRIGHT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags[TOPLEFT_TOPRIGHT] == 1)
						{
							extra_x = j; extra_y = i;
							for(ll=tempflags[TOPLEFT_TOPRIGHT]+tempflags[TOPLEFT_BOTTOMRIGHT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPRIGHT_BOTTOMRIGHT] == 1 && tempflags[TOPLEFT_BOTTOMRIGHT] == 1)
						{
							xint[count] = j+1; yint[count++] = i+1;
						}

						area = polyArea(xint,yint,count); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}//close for loop
				}
			}
			/***********************************************/
			/* image 2 is flat and image 1 is not flat */
			else if (a22 == 0 && b22 == 0)
			{
				ind2 = pairs[0][1];
				if (b21 == 0) // image 1 is vertically flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind1 = pairs[k][0];
						count = 0;
						if ((ind1 >= i1_topright && ind1 <= i1_topleft) || (ind1 <= i1_topright && ind1 >= i1_topleft))
						{
							yint[count] = y1; 
							xint[count++] = x1+(ind1-i1_topleft)/(i1_topright-i1_topleft);
						}
						if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
						{
							xint[count] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						
						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
						{
							xint[count] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						if ((ind1+1 >= i1_topright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_topright && ind1+1 >= i1_topleft))
						{
							yint[count] = y1; 
							xint[count++] = x1+(ind1+1-i1_topleft)/(i1_topright-i1_topleft);
						}
						
						area = polyArea(xint,yint,count); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else if (a21 == 0) // image 1 is horizontally flat
				{
					for(k=0;k<numpairs;k++)
					{
						ind1 = pairs[k][0];
						count = 0;
						if ((ind1 >= i1_topright && ind1 <= i1_bottomright) || (ind1 <= i1_topright && ind1 >= i1_bottomright))
						{
							xint[count] = x2; 
							yint[count++] = y2+(ind1-i1_topright)/(i1_bottomright-i1_topright);
						}
						if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
						{
							xint[count] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						
	
						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
						{
							xint[count] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
						}
						if ((ind1+1 >= i1_topright && ind1+1 <= i1_bottomright) || (ind1+1 <= i1_topright && ind1+1 >= i1_bottomright))
						{
							xint[count] = x2; 
							yint[count++] = y2+(ind1+1-i1_topright)/(i1_bottomright-i1_topright);
						}
						
						area = polyArea(xint,yint,count); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
				else // image 1 is neither vertically nor horizontally flat
				{
					for(k=0;k<numpairs;k++)	
					{
						ind1 = pairs[k][0];	
						tempflags[0] = tempflags[1] = tempflags[2] = 0;
	
						count = 0;	fl = 0;				
						if (b21 != 0)
						{
							if ((ind1 >= i1_topright && ind1 <= i1_bottomright) || (ind1 <= i1_topright && ind1 >= i1_bottomright))
							{
								tempflags[TOPRIGHT_BOTTOMRIGHT]++;
								xint[count] = x2; yint[count++] = y2+(ind1-i1_topright)/(i1_bottomright-i1_topright);	
								fl++;
							}

							if ((ind1+1 >= i1_topright && ind1+1 <= i1_bottomright) || (ind1+1 <= i1_topright && ind1+1 >= i1_bottomright))
							{
								tempflags[TOPRIGHT_BOTTOMRIGHT]++;
								xint[count] = x2; yint[count++] = y2+(ind1+1-i1_topright)/(i1_bottomright-i1_topright);	
								fl++;
							}

							if (fl == 2 && yint[count-1] > yint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}


						fl = 0;
						if (a21 != 0)
						{
							if ((ind1 >= i1_topright && ind1 <= i1_topleft) || (ind1 <= i1_topright && ind1 >= i1_topleft))
							{
								tempflags[TOPLEFT_TOPRIGHT]++;
								yint[count] = y1; xint[count++] = x1+(ind1-i1_topleft)/(i1_topright-i1_topleft);
								fl++;
							}

							if ((ind1+1 >= i1_topright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_topright && ind1+1 >= i1_topleft))
							{
								tempflags[TOPLEFT_TOPRIGHT]++;
								yint[count] = y1; xint[count++] = x1+(ind1+1-i1_topleft)/(i1_topright-i1_topleft);
								fl++;
							}

							if (fl == 2 && xint[count-1] > xint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						fl = 0;
						if (i1_topleft != i1_bottomright)
						{
							if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
								yint[count++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
								fl++;
							}

							if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
							{
								tempflags[TOPLEFT_BOTTOMRIGHT]++;
								xint[count] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
								yint[count++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
								fl++;
							}

							if (fl == 2 && yint[count-1] < yint[count-2])
							{
								swap(&yint[count-1],&yint[count-2]);
								swap(&xint[count-1],&xint[count-2]);
							}
						}

						if (tempflags[TOPLEFT_TOPRIGHT] == 1 && tempflags[TOPRIGHT_BOTTOMRIGHT] == 1)
						{
							extra_x = j+1; extra_y = i;
							for(ll=tempflags[TOPRIGHT_BOTTOMRIGHT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags[TOPLEFT_TOPRIGHT] == 1)
						{
							extra_x = j; extra_y = i;
							for(ll=tempflags[TOPLEFT_TOPRIGHT]+tempflags[TOPLEFT_BOTTOMRIGHT]; ll<count;ll++)
							{
								swap(&extra_x,&xint[ll]); swap(&extra_y,&yint[ll]);
							}
							xint[count] = extra_x; yint[count++] = extra_y;
						}
						else if (tempflags[TOPRIGHT_BOTTOMRIGHT] == 1 && tempflags[TOPLEFT_BOTTOMRIGHT] == 1)
						{
							xint[count] = j+1; yint[count++] = i+1;
						}

						area = polyArea(xint,yint,count); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xint,yint,count);
					}
				}
			}
			/***********************************************/
			/* neither of the two images is flat but gradients from the two images are parallel or coincident */
			else if (d2 == 0)
			{
				for(k=0;k<numpairs;k++)	
				{
					ind1 = pairs[k][0]; ind2 = pairs[k][1];	
					tempflags1[0] = tempflags1[1] = tempflags1[2] = 0;
					tempflags2[0] = tempflags2[1] = tempflags2[2] = 0;
					count_1 = 0; fl = 0;					
					if (b21 != 0)
					{
						if ((ind1 >= i1_topright && ind1 <= i1_bottomright) || (ind1 <= i1_topright && ind1 >= i1_bottomright))
						{
							tempflags1[TOPRIGHT_BOTTOMRIGHT]++;
							xint_1[count_1] = x2; yint_1[count_1++] = y2+(ind1-i1_topright)/(i1_bottomright-i1_topright);
							fl++;	
						}
						if ((ind1+1 >= i1_topright && ind1+1 <= i1_bottomright) || (ind1+1 <= i1_topright && ind1+1 >= i1_bottomright))
						{
							tempflags1[TOPRIGHT_BOTTOMRIGHT]++;
							xint_1[count_1] = x2; yint_1[count_1++] = y2+(ind1+1-i1_topright)/(i1_bottomright-i1_topright);	
							fl++;
						}

						// y closer towards bottom should occur first
						if (fl == 2 && yint_1[count_1-1] > yint_1[count_1-2])
						{
							swap(&yint_1[count_1-1],&yint_1[count_1-2]);
							swap(&xint_1[count_1-1],&xint_1[count_1-2]);
						}
					}

					fl = 0;
					if (a21 != 0)
					{
						if ((ind1 >= i1_topright && ind1 <= i1_topleft) || (ind1 <= i1_topright && ind1 >= i1_topleft))
						{
							tempflags1[TOPLEFT_TOPRIGHT]++;
							yint_1[count_1] = y1; xint_1[count_1++] = x1+(ind1-i1_topleft)/(i1_topright-i1_topleft);
							fl++;
						}
						if ((ind1+1 >= i1_topleft && ind1+1 <= i1_topright) || (ind1+1 <= i1_topleft && ind1+1 >= i1_topright))
						{
							tempflags1[TOPLEFT_TOPRIGHT]++;
							yint_1[count_1] = y1; xint_1[count_1++] = x1+(ind1+1-i1_topleft)/(i1_topright-i1_topleft);
							fl++;
						}

						if (fl == 2 && xint_1[count_1-1] > xint_1[count_1-2])
						{
							swap(&yint_1[count_1-1],&yint_1[count_1-2]);
							swap(&xint_1[count_1-1],&xint_1[count_1-2]);
						}
					}

					fl = 0;
					if (i1_topleft != i1_bottomright)
					{
						if ((ind1 >= i1_bottomright && ind1 <= i1_topleft) || (ind1 <= i1_bottomright && ind1 >= i1_topleft))
						{
							tempflags1[TOPLEFT_BOTTOMRIGHT]++;
							xint_1[count_1] = x1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint_1[count_1++] = y1+(ind1-i1_topleft)/(i1_bottomright-i1_topleft);
							fl++;
						}

						if ((ind1+1 >= i1_bottomright && ind1+1 <= i1_topleft) || (ind1+1 <= i1_bottomright && ind1+1 >= i1_topleft))
						{
							tempflags1[TOPLEFT_BOTTOMRIGHT]++;
							xint_1[count_1] = x1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							yint_1[count_1++] = y1+(ind1+1-i1_topleft)/(i1_bottomright-i1_topleft);
							fl++;
						}

						if (fl == 2 && yint_1[count_1-1] < yint_1[count_1-2])
						{
							swap(&yint_1[count_1-1],&yint_1[count_1-2]);
							swap(&xint_1[count_1-1],&xint_1[count_1-2]);
						}
					}
	

					if (tempflags1[TOPLEFT_TOPRIGHT] == 1 && tempflags1[TOPRIGHT_BOTTOMRIGHT] == 1)
					{
						extra_x = j+1; extra_y = i;
						for(ll=tempflags1[TOPRIGHT_BOTTOMRIGHT]; ll<count_1;ll++)
						{
							swap(&extra_x,&xint_1[ll]); swap(&extra_y,&yint_1[ll]);
						}
						xint_1[count_1] = extra_x; yint_1[count_1++] = extra_y;
					}
					else if (tempflags1[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags1[TOPLEFT_TOPRIGHT] == 1)
					{
						extra_x = j; extra_y = i;
						for(ll=tempflags1[TOPLEFT_TOPRIGHT]+tempflags1[TOPLEFT_BOTTOMRIGHT]; ll<count_1;ll++)
						{
							swap(&extra_x,&xint_1[ll]); swap(&extra_y,&yint_1[ll]);
						}
						xint_1[count_1] = extra_x; yint_1[count_1++] = extra_y;
					}
					else if (tempflags1[TOPRIGHT_BOTTOMRIGHT] == 1 && tempflags1[TOPLEFT_BOTTOMRIGHT] == 1)
					{
						xint_1[count_1] = j+1; yint_1[count_1++] = i+1;
					}

					count_2 = 0;	fl = 0;				
					if (b22 != 0)
					{
						if ((ind2 >= i2_topright && ind2 <= i2_bottomright) || (ind2 <= i2_topright && ind2 >= i2_bottomright))
						{
							tempflags2[TOPRIGHT_BOTTOMRIGHT]++;
							xint_2[count_2] = x2; yint_2[count_2++] = y2+(ind2-i2_topright)/(i2_bottomright-i2_topright);	
							fl++;
						}
						if ((ind2+1 >= i2_topright && ind2+1 <= i2_bottomright) || (ind2+1 <= i2_topright && ind2+1 >= i2_bottomright))
						{
							tempflags2[TOPRIGHT_BOTTOMRIGHT]++;
							xint_2[count_2] = x2; yint_2[count_2++] = y2+(ind2+1-i2_topright)/(i2_bottomright-i2_topright);	
							fl++;
						}
						if (fl == 2 && yint_2[count_2-1] > yint_2[count_2-2])
						{
							swap(&yint_2[count_2-1],&yint_2[count_2-2]);
							swap(&xint_2[count_2-1],&xint_2[count_2-2]);
						}
					}

					fl = 0;
					if (a22 != 0)
					{
						if ((ind2 >= i2_topleft && ind2 <= i2_topright) || (ind2 <= i2_topleft && ind2 >= i2_topright))
						{
							tempflags2[TOPLEFT_TOPRIGHT]++;
							yint_2[count_2] = y1; xint_2[count_2++] = x1+(ind2-i2_topleft)/(i2_topright-i2_topleft);
							fl++;
						}
						if ((ind2+1 >= i2_topleft && ind2+1 <= i2_topright) || (ind2+1 <= i2_topleft && ind2+1 >= i2_topright))
						{
							tempflags2[TOPLEFT_TOPRIGHT]++;
							yint_2[count_2] = y1; xint_2[count_2++] = x1+(ind2+1-i2_topleft)/(i2_topright-i2_topleft);
							fl++;
						}

						if (fl == 2 && xint_2[count_2-1] > xint_2[count_2-2])
						{
							swap(&yint_2[count_2-1],&yint_2[count_2-2]);
							swap(&xint_2[count_2-1],&xint_2[count_2-2]);
						}
					}

					fl = 0;
					if (i2_topleft != i2_bottomright)
					{
						if ((ind2 >= i2_bottomright && ind2 <= i2_topleft) || (ind2 <= i2_bottomright && ind2 >= i2_topleft))
						{
							tempflags2[TOPLEFT_BOTTOMRIGHT]++;
							xint_2[count_2] = x1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							yint_2[count_2++] = y1+(ind2-i2_topleft)/(i2_bottomright-i2_topleft);
							fl++;
						}
						if ((ind2+1 >= i2_bottomright && ind2+1 <= i2_topleft) || (ind2+1 <= i2_bottomright && ind2+1 >= i2_topleft))
						{
							tempflags2[TOPLEFT_BOTTOMRIGHT]++;
							xint_2[count_2] = x1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							yint_2[count_2++] = y1+(ind2+1-i2_topleft)/(i2_bottomright-i2_topleft);
							fl++;
						}

						if (fl == 2 && yint_2[count_2-1] < yint_2[count_2-2])
						{
							swap(&yint_2[count_2-1],&yint_2[count_2-2]);
							swap(&xint_2[count_2-1],&xint_2[count_2-2]);
						}
					}
	
			
					if (tempflags2[TOPLEFT_TOPRIGHT] == 1 && tempflags2[TOPRIGHT_BOTTOMRIGHT] == 1)
					{
						extra_x = j+1; extra_y = i;
						for(ll=tempflags2[TOPRIGHT_BOTTOMRIGHT]; ll<count_2;ll++)
						{
							swap(&extra_x,&xint_2[ll]); swap(&extra_y,&yint_2[ll]);
						}
						xint_2[count_2] = extra_x; yint_2[count_2++] = extra_y;
					}
					else if (tempflags2[TOPLEFT_BOTTOMRIGHT] == 1 && tempflags2[TOPLEFT_TOPRIGHT] == 1)
					{
						extra_x = j; extra_y = i;
						for(ll=tempflags2[TOPLEFT_TOPRIGHT]+tempflags2[TOPLEFT_BOTTOMRIGHT]; ll<count_2;ll++)
						{
							swap(&extra_x,&xint_2[ll]); swap(&extra_y,&yint_2[ll]);
						}
						xint_2[count_2] = extra_x; yint_2[count_2++] = extra_y;
					}
					else if (tempflags2[TOPRIGHT_BOTTOMRIGHT] == 1 && tempflags2[TOPLEFT_BOTTOMRIGHT] == 1)
					{
						xint_2[count_2] = j+1; yint_2[count_2++] = i+1;
					}

					polyClip(xint_1,yint_1,count_1,xint_2,yint_2,count_2,xout,yout,&Nout);
					area = polyArea(xout,yout,Nout); total_area += area;pix_area2 += area;
					joint_pdf[ind1][ind2] += area;
					write_poly (xout,yout,Nout);
				}
			}
				
			/* neither of the pathological cases! */
			else
			{
				for(k=0;k<numpairs;k++)	
				{
					ind1 = pairs[k][0];
					ind2 = pairs[k][1];
					xint1 = (b22*(ind1-c21)-b21*(ind2-c22))/d2;
					yint1 = (-a22*(ind1-c21)+a21*(ind2-c22))/d2;
	
					xint2 = (b22*(ind1-c21+1)-b21*(ind2-c22))/d2;
					yint2 = (-a22*(ind1-c21+1)+a21*(ind2-c22))/d2;
	
					xint4 = (b22*(ind1-c21)-b21*(ind2-c22+1))/d2;
					yint4 = (-a22*(ind1-c21)+a21*(ind2-c22+1))/d2;
	
					xint3 = (b22*(ind1-c21+1)-b21*(ind2-c22+1))/d2;
					yint3 = (-a22*(ind1-c21+1)+a21*(ind2-c22+1))/d2;
	
					f1 = insideTri(xint1,yint1,(double)i,(double)j,RIGHT);
					f2 = insideTri(xint2,yint2,(double)i,(double)j,RIGHT);
					f3 = insideTri(xint3,yint3,(double)i,(double)j,RIGHT);
					f4 = insideTri(xint4,yint4,(double)i,(double)j,RIGHT);
					f = f1+f2+f3+f4;
	
					xint[0] = xint1; xint[1] = xint2; xint[2] = xint3; xint[3] = xint4;
					yint[0] = yint1; yint[1] = yint2; yint[2] = yint3; yint[3] = yint4;
	
					if (f == 4)
					{
						area = polyArea(xint,yint,4); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area; 
						write_poly(xint,yint,4);
					}
					else
					{
						polyClip(xint,yint,4,xtri,ytri,3,xout,yout,&Nout);
						area = polyArea(xout,yout,Nout); total_area += area;pix_area2 += area;
						joint_pdf[ind1][ind2] += area;
						write_poly (xout,yout,Nout);
					}				
				}
			}
	
			//if (numpairs > 0) free_2d_double(pairs,numpairs);

end_pixel:	
			if( VERBOSE	== 1)
			{
				printf ("\tpix_area = %f, %f",pix_area1,pix_area2); fflush(stdout);
				printf ("\t Nflag = %d",nflag);
				if ((nflag == 0 && pix_area1 + pix_area2 < 0.5000) || (nflag == 1 && pix_area1 + pix_area2 < 0.2500))
				{
					printf ("\n!!!! [%d %d]",i,j); fflush(stdout);
				}
			}
		} // close for lopp for 'j'
	}// close for loop for 'i'


	sum = 0;
	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			sum += joint_pdf[i][j];
		}
	}
	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			joint_pdf[i][j] /= sum;
		}
	}

}

void joint_density_histograms (double **im1, double **im2,double **joint_pdf)
{
	int i,j;
	double sum = 0,minim1,minim2,maxim1,maxim2;

	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			joint_pdf[i][j] = 0;
		}
	}

	max_min_image(im1,&minim1,&maxim1);
	max_min_image(im2,&minim2,&maxim2);

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			if (im1[i][j] < 0 || im2[i][j] < 0) continue;
			im1[i][j] = floor((NL-1)*(im1[i][j]-minim1)/(maxim1-minim1));
			im2[i][j] = floor((NL-1)*(im2[i][j]-minim2)/(maxim2-minim2));
			joint_pdf[(int)im1[i][j]][(int)im2[i][j]] += 1;
		}
	}

	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			sum += joint_pdf[i][j];
		}
	}

	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			joint_pdf[i][j] /= sum;
		}
	}

}


void find_marginals (double *p1,double *p2,double **joint_pdf)
{
	int i,j;

	for(i=0;i<NL;i++)
	{
		p1[i] = 0;
		for(j=0;j<NL;j++)
		{
			p1[i] += joint_pdf[i][j];
		}
	}

	for(j=0;j<NL;j++)
	{
		p2[j] = 0;
		for(i=0;i<NL;i++)
		{
			p2[j] += joint_pdf[i][j];
		}
	}

}

void write_pdf_joint (double **joint_pdf,char *filename)
{
	int i,j;
	FILE *fp;

	fp = fopen (filename,"w");
	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			fprintf (fp,"%lf ",joint_pdf[i][j]);
		}
		fprintf (fp,"\n");
	}
	fclose (fp);
}

void write_pdf_marginal (double *pdf,char *filename)
{
	int i;
	FILE *fp;

	fp = fopen (filename,"w");
	for(i=0;i<NL;i++)
	{
		fprintf (fp,"%lf ",pdf[i]);
	}
	fclose (fp);
}
