%Code for Compact Image Representation/Compression using Sparse Matrix Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%



function testNewImage(U,V,patchSize,testImgDirectory,str,errTh,fracBit,ext)
    rank_u = size(U,2);
    rank_v = size(V,2);
    patchSize_prod = patchSize(1)*patchSize(2);
    dirName = strcat(testImgDirectory,'/*.',ext);
    files = dir(dirName);
    error = zeros(1,length(files));
    psnr = zeros(1,length(files));
    R = zeros(1,length(files));
    avgCoeffs = zeros(1,length(files));
    q_frac = quantizer('ufixed', 'round', 'saturate', [fracBit+1 fracBit]);
    M = size(U,3);
    symbols = 1:rank_u*rank_v;
    symbols_Clus = 1:M;
    rangeVal = ceil(sqrt(patchSize_prod));
    symbols_IntVals = -rangeVal:rangeVal;
    minMat = -patchSize(1)*ones(rank_u,rank_v);
    maxMat = patchSize(1)*ones(rank_u,rank_v);
    for numImg = 1:length(files)
        tic;
        nonZeroLocations = zeros(1,rank_u*rank_v);
        numStorage = zeros(1,rank_u*rank_v);
        clusterNum = zeros(1,M);
        Num_IntVal = zeros(1,rangeVal*2+1);
        testImgName = strcat(testImgDirectory,'/',files(numImg).name);
        [X,DS,originalImg] = getImageParts(testImgName,patchSize);
        maxPixelVal = max(max(originalImg));
        originalImg = originalImg/maxPixelVal;
        X = X / maxPixelVal;
        [rows cols] = size(originalImg);
        constructedImg = zeros(rows,cols); 
        N = size(X,3);
        storage = zeros(1,N);
        for i = 1:N
            errorMat = zeros(1,M);
            index = zeros(1,M);
            S = zeros([rank_u rank_v M]);
            for a = 1:M
                S_tild = U(:,:,a)'*X(:,:,i)*V(:,:,a);
                %tempMat = quantize(q,tempMat); 
                tempVec = reshape(S_tild,1,rank_u*rank_v);
                sparseVec = zeros(1,rank_u*rank_v);
                [sortVec IX] = sort(abs(tempVec),'descend');
                avgPatchError = norm(X(:,:,i),'fro')^2/patchSize_prod;
                while((avgPatchError>errTh) && (index(a)<(rank_u*rank_v)))
                    index(a) = index(a) + 1;
                    pos = IX(index(a));
                    sparseVec(pos) = tempVec(pos);
                    avgPatchError = avgPatchError - (tempVec(pos)^2/patchSize_prod);
                    %fprintf('PatchError...%f\n',avgPatchError);
                end
                S(:,:,a) = reshape(sparseVec,rank_u,rank_v);
                errorMat(a) = norm(X(:,:,i)-U(:,:,a)*S(:,:,a)*V(:,:,a)','fro');
                clear tempVec;
            end
            [numZeros a] = min(index);
            if(numZeros == rank_u*rank_v)
                %fprintf('This error cannot be reached....\n');
                [errorVal a] = min(errorMat);
            end
            clusterNum(a) = clusterNum(a) + 1;
            Sia = S(:,:,a);
            %Values should lie between -12 to 12%
            Sia = max(minMat,Sia);
            Sia = min(maxMat,Sia);
            S_int = floor(Sia);
            temp_int = reshape(S_int,1,rank_u*rank_v);
            S_frac = Sia - S_int;
            coded_S_frac = quantize(q_frac,S_frac);
            coded_S = S_int + coded_S_frac;
            tempVec = reshape(coded_S,1,rank_u*rank_v);
            nonZeroLoc = find(tempVec);
            nonZero_Int = temp_int(nonZeroLoc);
            unique_Ele = unique(nonZero_Int);
            for len = 1:length(unique_Ele)
                position = find(nonZero_Int==unique_Ele(len));
                Num_IntVal(unique_Ele(len)+rangeVal+1) = Num_IntVal(unique_Ele(len)+rangeVal+1)+length(position);
                clear position;
            end
            clear unique_Ele temp_int;
            storageReqd = length(nonZeroLoc);
            storage(i) = storageReqd;
            %Huffmann encoding
            if(storageReqd~=0)
                nonZeroLocations(nonZeroLoc) = nonZeroLocations(nonZeroLoc) + 1;
                numStorage(storageReqd) =  numStorage(storageReqd) + 1;
            end
            reconstructedPatch = U(:,:,a)*coded_S*V(:,:,a)';
            startRow = DS(i).startRow;
            endRow = DS(i).endRow;
            startCol = DS(i).startCol;
            endCol = DS(i).endCol;
            constructedImg(startRow:endRow,startCol:endCol) = reconstructedPatch;
            %fprintf('Storage Required = %f...Error = %f\n',storageReqd,(norm(X(:,:,i)-Z(:,:,i),'fro')^2)/patchSize_prod);
            %pause();
        end
        diffImg = abs(originalImg - constructedImg);
        error(numImg) = norm(diffImg,'fro')^2;
        error(numImg) = error(numImg)/(rows*cols);
        psnr(numImg) = -10*log10(error(numImg));
        %fprintf('Error Value...%f\n',error);
        avgStorageForImg = mean(storage);
        p_b = nonZeroLocations / sum(nonZeroLocations);
        p_a = numStorage / sum(numStorage);
        p_c = clusterNum / sum(clusterNum);
        p_d = Num_IntVal / sum(Num_IntVal);
        set(0,'RecursionLimit',1000);
        [huffmanndict_b b] =  huffmandict(symbols,p_b);
        [huffmanndict_a a] =  huffmandict(symbols,p_a);
        [huffmanndict_c c] =  huffmandict(symbols_Clus,p_c);
        [huffmanndict_d d] =  huffmandict(symbols_IntVals,p_d);
        fprintf('Value of d = %f\n',d);
        numCoeffs = sum(storage);
        numPixels = N*patchSize_prod;
        R(numImg) = ((a+c)*N + numCoeffs*(b+d+fracBit))/numPixels;
        fprintf('imgName = %s.....error = %f...psnr = %f...R = %f\n',testImgName,error(numImg),psnr(numImg),R(numImg));
        fprintf('Average storage per patch for this img...%f\n',avgStorageForImg);
        avgCoeffs(numImg) = avgStorageForImg;
        %constructedImg = constructedImg* maxPixelVal;
        %imwrite(uint8(constructedImg),'montreal_002.pgm','pgm');
        clear X originalImg constructedImg diffImg DS ; 
        timeTaken = toc;
%         fprintf('Time taken for an image = %d\n',timeTaken);
%         pause;
    end
    avgR = mean(R);
    avgPSNR = mean(psnr);
    avgCoeff_AllImages = mean(avgCoeffs);
    avg_Vals = [avgR avgPSNR avgCoeff_AllImages];
    fprintf('Avg R = %f....Avg PSNR = %f...Avg Coeff = %f\n',avgR,avgPSNR,avgCoeff_AllImages);
    %disp(psnr');
    errorFileName = strcat('Error',str);
    %save(errorFileName,'error');
    psnrFileName = strcat('PSNR',str);
    %save(psnrFileName,'psnr');
    RFileName = strcat('R',str);
    %save(RFileName,'R');
    avgCoeffFileName = strcat('avgCoeff',str);
    %save(avgCoeffFileName,'avgCoeffs');
    avgValsFileName = strcat('avgVals_MoreNoise',str);
    save(avgValsFileName,'avg_Vals');
end
