package JIMSwingGUI;

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.metal.MetalLookAndFeel;

// ===================================================================================
// CLASS:		SourceListCellRenderer
// FUNCTION:	Renders source code lines in a JList
//			Each line rendered as a JTextField
//			Sets color depending upon selection
//			Maintains internal formatting of text lines
// ===================================================================================
// javadoc comments follow
// ===================================================================================
/**
  * This is the SourceListCellRenderer class.
  *
  * @author Fred Williams
*/
public class SourceListCellRenderer extends JTextField implements ListCellRenderer
{
	public SourceListCellRenderer()
	{
		super();
		setOpaque(true);
	}

	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
	{
		setFont(new Font("monospaced", 0, 12));
		setText(value.toString());
		setBorder(null);
		if (isSelected)
		{
			setBackground(MetalLookAndFeel.getTextHighlightColor());
		}
		else
		{
			setBackground(MetalLookAndFeel.getWhite());
		}
		return this;
	}
}
