package JIMSwingGUI;

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

/**
  * This is the SourceFileFilter class.
  *
  * @author Fred Williams
*/
public class SourceFileFilter extends FileFilter
{
	public boolean accept(File f)
	{
		if (f.isDirectory())
		{
			return true;
		}
		String extension = getExtension(f);
		if (extension != null)
		{
			if (extension.equals("s") || extension.equals("asm"))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		return false;
	}
	
	public String getDescription()
	{
		return "Assembly files (*.s, *.asm)";
	}

	private static String getExtension(File f)
	{
		String ext = null;
		String s = f.getName();
		int i = s.lastIndexOf('.');
		if (i > 0 &&  i < s.length() - 1)
		{
			ext = s.substring(i+1).toLowerCase();
		}
		return ext;
	}
}