package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import JIMSCore.*;

/**
  * This is the SettingsDialog class.
  *
  * @author Fred Williams
*/
class SettingsDialog extends JDialog implements ActionListener
{
	public SettingsDialog(TopLevelWindow frame, boolean GPR, boolean SFP, boolean DFP, boolean ignoreAT)
	{
		super(frame, "Settings", true);

		parent = frame;

		JLabel GPRLabel = new JLabel("General Purpose registers: ");
		GPRHexButton = new JRadioButton("Hexadecimal", GPR);
		GPRDecimalButton = new JRadioButton("Decimal", !(GPR));
		ButtonGroup GPRButtons = new ButtonGroup();
		GPRButtons.add(GPRHexButton);
		GPRButtons.add(GPRDecimalButton);

		JPanel GPRPanel = new JPanel();
		GPRPanel.setLayout(new BoxLayout(GPRPanel, BoxLayout.X_AXIS));
		GPRPanel.add(GPRLabel);
		GPRPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		GPRPanel.add(GPRHexButton);
		GPRPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		GPRPanel.add(GPRDecimalButton);

		JLabel SFPLabel = new JLabel("Single precision Floating Point registers: ");
		SFPHexButton = new JRadioButton("Hexadecimal", SFP);
		SFPDecimalButton = new JRadioButton("Decimal", !(SFP));
		ButtonGroup SFPButtons = new ButtonGroup();
		SFPButtons.add(SFPHexButton);
		SFPButtons.add(SFPDecimalButton);

		JPanel SFPPanel = new JPanel();
		SFPPanel.setLayout(new BoxLayout(SFPPanel, BoxLayout.X_AXIS));
		SFPPanel.setBorder(BorderFactory.createEmptyBorder(5,5,0,5)); 
		SFPPanel.add(SFPLabel);
		SFPPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		SFPPanel.add(SFPHexButton);
		SFPPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		SFPPanel.add(SFPDecimalButton);

		JLabel DFPLabel = new JLabel("Double precision Floating Point registers: ");
		DFPHexButton = new JRadioButton("Hexadecimal", DFP);
		DFPDecimalButton = new JRadioButton("Decimal", !(DFP));
		ButtonGroup DFPButtons = new ButtonGroup();
		DFPButtons.add(DFPHexButton);
		DFPButtons.add(DFPDecimalButton);

		JPanel DFPPanel = new JPanel();
		DFPPanel.setLayout(new BoxLayout(DFPPanel, BoxLayout.X_AXIS));
		DFPPanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5)); 
		DFPPanel.add(DFPLabel);
		DFPPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		DFPPanel.add(DFPHexButton);
		DFPPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		DFPPanel.add(DFPDecimalButton);
		
		JPanel displayPanel = new JPanel();
		displayPanel.setLayout(new BoxLayout(displayPanel, BoxLayout.Y_AXIS));
		displayPanel.setBorder(BorderFactory.createTitledBorder("Display")); 
		displayPanel.add(GPRPanel);
		displayPanel.add(SFPPanel);
		displayPanel.add(DFPPanel);

		ignoreInvalidAT = new JCheckBox("Ignore invalid use of $at", ignoreAT);
		ignoreInvalidAT.setBorder(BorderFactory.createEmptyBorder(10,10,10,10)); 
		JPanel atRegisterPanel = new JPanel();
		atRegisterPanel.setLayout(new BoxLayout(atRegisterPanel, BoxLayout.X_AXIS));
		atRegisterPanel.setBorder(BorderFactory.createTitledBorder("$at Register")); 
		atRegisterPanel.add(ignoreInvalidAT);

		applyButton = new JButton("Apply");
		getRootPane().setDefaultButton(applyButton);
		applyButton.addActionListener(this);
		closeButton = new JButton("Close");
		closeButton.setMnemonic(KeyEvent.VK_C);
		closeButton.addActionListener(this);
		
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(10,5,10,5)); 
		buttonPanel.add(applyButton);
		buttonPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		buttonPanel.add(closeButton);
		
		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		contentPane.setBorder(BorderFactory.createEmptyBorder(12,12,11,11)); 
		contentPane.add(displayPanel);
		contentPane.add(atRegisterPanel);
		contentPane.add(buttonPanel);
		
		setContentPane(contentPane);
		pack();
		setResizable(false);
		setLocation(new Point(frame.getX() + ((frame.getWidth()-this.getWidth()) / 2), frame.getY() + ((frame.getHeight()-this.getHeight()) / 2)));
		setVisible(true);
	}


	public void actionPerformed(ActionEvent ae)
	{
		Object source = ae.getSource();
		if (source == applyButton)
		{
			parent.updateSettings(GPRHexButton.isSelected(), SFPHexButton.isSelected(), DFPHexButton.isSelected(), ignoreInvalidAT.isSelected());
		}
		if (source == closeButton)
		{
			dispose();
		}
	}

	private TopLevelWindow parent;
	private JRadioButton GPRHexButton;
	private JRadioButton GPRDecimalButton;
	private JRadioButton SFPHexButton;
	private JRadioButton SFPDecimalButton;
	private JRadioButton DFPHexButton;
	private JRadioButton DFPDecimalButton;
	private JCheckBox ignoreInvalidAT;
	private JButton applyButton;
	private JButton closeButton;
}
