package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import JIMSCore.*;

/**
  * This is the RegisterEditDialog class.
  *
  * @author Fred Williams
*/
class RegisterEditDialog extends JDialog implements ActionListener
{
	public RegisterEditDialog(TopLevelWindow frame, CommandProcessor cp)
	{
		super(frame, "Modify register", true);
		returnValue = null;
		setUpRegisterVectors();

		parent = frame;

		setList = new Vector();
		setList.addElement("General Purpose");
		setList.addElement("Floating Point");

		commandProcessor = cp;
		JLabel setLabel = new JLabel("Set: ");
		setListBox = new JComboBox(setList);
		setListBox.setSelectedIndex(0);
		setListBox.addActionListener(this);
		JLabel regLabel = new JLabel("Register: ");

		regList = new JComboBox();
		Enumeration e = registersAsList.elements();
		while (e.hasMoreElements())
		{
			String reg = (String)e.nextElement();
			regList.addItem(reg);
		}

		JLabel textLabel = new JLabel("Value: ");
		value = new JTextField();
		applyButton = new JButton("Apply");
		applyButton.setDefaultCapable(true);
		getRootPane().setDefaultButton(applyButton);
		applyButton.addActionListener(this);
		closeButton = new JButton("Close");
		closeButton.setMnemonic(KeyEvent.VK_C);
		closeButton.addActionListener(this);

		JPanel ButtonPanel = new JPanel();
		ButtonPanel.setLayout(new BoxLayout(ButtonPanel, BoxLayout.X_AXIS));
		ButtonPanel.add(applyButton);
		ButtonPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		ButtonPanel.add(closeButton);

		JPanel intermediatePane1 = new JPanel();
		intermediatePane1.setLayout(new GridLayout(0,2,5,10));
		intermediatePane1.setBorder(BorderFactory.createEmptyBorder(0,5,10,5)); 

		intermediatePane1.add(setLabel);
		intermediatePane1.add(setListBox);
		intermediatePane1.add(regLabel);
		intermediatePane1.add(regList);
		intermediatePane1.add(textLabel);
		intermediatePane1.add(value);

		JPanel intermediatePane2 = new JPanel();
		intermediatePane2.setLayout(new BoxLayout(intermediatePane2, BoxLayout.Y_AXIS));
		intermediatePane2.add(intermediatePane1);
		intermediatePane2.add(ButtonPanel);

		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(new JPanel(), BorderLayout.NORTH);
		contentPane.add(new JPanel(), BorderLayout.SOUTH);
		contentPane.add(new JPanel(), BorderLayout.WEST);
		contentPane.add(new JPanel(), BorderLayout.EAST);
		contentPane.add(intermediatePane2, BorderLayout.CENTER);

		setContentPane(contentPane);
		setResizable(false);
		pack();
		setLocation(new Point(frame.getX() + ((frame.getWidth()-this.getWidth()) / 2), frame.getY() + ((frame.getHeight()-this.getHeight()) / 2)));
		setVisible(true);
	}

	public void actionPerformed(ActionEvent ae)
	{
		Object source = ae.getSource();
		if (source == applyButton)
		{
			String sRegister = ((String)regList.getSelectedItem()).toUpperCase();
			String sValue = value.getText();
			String sSet = new String();
			Enumeration e = registersAndSets.elements();
			while (e.hasMoreElements())
			{
				registerInfo info = (registerInfo)e.nextElement();
				String n = info.getName();
				if (sRegister.equals(n))
				{
					sSet = info.getSet();
					break;
				}
			}
			float decimalFloat = 0;
			boolean isFloatInput = false;
			if (sSet == "CP1")
			{
				if (!(sValue.toUpperCase().startsWith("0X")))
				{
					isFloatInput = true;
					decimalFloat = Float.parseFloat(sValue);
					sValue = Long.toString((long)Float.floatToIntBits(decimalFloat));
				}
			}
			String command = "SET REGISTER " + sSet + " $" + sRegister + " " + sValue;
			CommandResultBuffer crb = commandProcessor.processCommand(command);
			returnValue = crb.sGetNextResponse();
			if (returnValue.startsWith("* SET DONE"))
			{
				if (isFloatInput)
				{
					JOptionPane.showMessageDialog(this, "Successfully set $" + sRegister + " to " + decimalFloat, "Success", JOptionPane.INFORMATION_MESSAGE);				
				}
				else
				{
					JOptionPane.showMessageDialog(this, "Successfully set $" + sRegister + " to " + sValue, "Success", JOptionPane.INFORMATION_MESSAGE);
				}
				parent.displayUpdate();
			}
			else
			{
				JOptionPane.showMessageDialog(this, "Invalid register or value.", "Error", JOptionPane.ERROR_MESSAGE);
			}
			value.setText(null);
		}
		if (source == closeButton)
		{
			dispose();
		}
		if (source == setListBox)
		{
			int set = setListBox.getSelectedIndex();
			if (set == 0)
			{
				regList.removeAllItems();
				Enumeration e = registersAsList.elements();
				while (e.hasMoreElements())
				{
					String reg = (String)e.nextElement();
					regList.addItem(reg);
				}
			}
			if (set == 1)
			{
				regList.removeAllItems();
				Enumeration e = floatingPointList.elements();
				while (e.hasMoreElements())
				{
					String reg = (String)e.nextElement();
					regList.addItem(reg);
				}
			}
		}
	}

	public String getReturnValue()
	{
		return returnValue;
	}

	private void setUpRegisterVectors()
	{
		registersAndSets = new Vector();
		registerInfo newInfo = new registerInfo("GPR", "PC");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "HI");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "LO");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "AT");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "V0");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "V1");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "A0");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "A1");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "A2");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "A3");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T0");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T1");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T2");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T3");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T4");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T5");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T6");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T7");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S0");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S1");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S2");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S3");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S4");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S5");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S6");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "S7");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T8");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "T9");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "K0");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "K1");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "GP");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "SP");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "FP");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("GPR", "RA");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("CP1", "FP0");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("CP1", "FP1");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("CP1", "FP2");
		registersAndSets.add(newInfo);
		newInfo = new registerInfo("CP1", "FP3");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP4");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP5");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP6");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP7");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP8");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP9");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP10");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP11");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP12");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP13");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP14");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP15");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP16");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP17");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP18");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP19");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP20");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP21");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP22");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP23");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP24");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP25");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP26");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP27");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP28");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP29");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP30");
		registersAndSets.add(newInfo);		
		newInfo = new registerInfo("CP1", "FP31");
		registersAndSets.add(newInfo);		
		registersAsList = new Vector();
		floatingPointList = new Vector();
		Enumeration e = registersAndSets.elements();
		while (e.hasMoreElements())
		{
			registerInfo info = (registerInfo)e.nextElement();
			if (info.getSet() == "GPR")
			{
				registersAsList.addElement(info.getName().toLowerCase());
			}
			if (info.getSet() == "CP1")
			{
				floatingPointList.addElement(info.getName().toLowerCase());
			}
		}		
	}

	private TopLevelWindow parent;
	private CommandProcessor commandProcessor;
	private static Vector registersAndSets;
	private static Vector registersAsList;
	private static Vector floatingPointList;
	private Vector setList;
	private JTextField value;
	private JComboBox regList;
	private JComboBox setListBox;
	private JButton applyButton;
	private JButton closeButton;
	private String returnValue;

	private class registerInfo
	{
		public registerInfo(String s, String n)
		{
			set = s;
			name = n;
		}
		public String getSet()
		{
			return set;
		}
		public String getName()
		{
			return name;
		}
		String set;
		String name;
	}
}
