package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import JIMSCore.*;

/**
  * This is the MemoryEditDialog class.
  *
  * @author Fred Williams
*/
class MemoryEditDialog extends JDialog implements ActionListener
{
	public MemoryEditDialog(TopLevelWindow frame, CommandProcessor cp)
	{
		super(frame, "Modify memory", true);
		commandProcessor = cp;

		parent = frame;

		JLabel startRangeLabel = new JLabel("Starting address: ");
		JLabel endRangeLabel = new JLabel("Ending address: ");
		memoryStart = new JTextField();
		memoryEnd = new JTextField();
		JLabel textLabel = new JLabel("Value: ");
		value = new JTextField();

		applyButton = new JButton("Apply");
		applyButton.setDefaultCapable(true);
		getRootPane().setDefaultButton(applyButton);
		applyButton.addActionListener(this);
		closeButton = new JButton("Close");
		closeButton.setMnemonic(KeyEvent.VK_C);
		closeButton.addActionListener(this);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(5,0,5,5)); 
		buttonPanel.add(applyButton);
		buttonPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		buttonPanel.add(closeButton);

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(0,2,5,10));
		mainPanel.setBorder(BorderFactory.createEmptyBorder(0,5,10,5)); 
		mainPanel.add(startRangeLabel);
		mainPanel.add(memoryStart);
		mainPanel.add(endRangeLabel);
		mainPanel.add(memoryEnd);
		mainPanel.add(textLabel);
		mainPanel.add(value);

		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		contentPane.setBorder(BorderFactory.createEmptyBorder(12,12,11,11)); 
		contentPane.add(mainPanel);
		contentPane.add(buttonPanel);

		setContentPane(contentPane);
		setResizable(false);
		pack();
		setLocation(new Point(frame.getX() + ((frame.getWidth()-this.getWidth()) / 2), frame.getY() + ((frame.getHeight()-this.getHeight()) / 2)));
		setVisible(true);
	}

	public void actionPerformed(ActionEvent ae)
	{
		Object source = ae.getSource();
		if (source == applyButton)
		{
			String sStartAddress = memoryStart.getText();
			String sEndAddress = memoryEnd.getText();
			String sValue = value.getText();
			String command = new String();
			if (sEndAddress.length() != 0)
			{
				command = "SET MEMORY " + sStartAddress + "-" + sEndAddress + " " + sValue;
			}
			else
			{
				command = "SET MEMORY " + sStartAddress + " " + sValue;
			}
			CommandResultBuffer crb = commandProcessor.processCommand(command);
			returnValue = crb.sGetNextResponse();
			if (returnValue.startsWith("* SET DONE"))
			{
				parent.displayUpdate();
				JOptionPane.showMessageDialog(this, "Successfully modified memory.", "Success", JOptionPane.INFORMATION_MESSAGE);	
			}
			else
			{
				JOptionPane.showMessageDialog(this, "Invalid range or value.", "Error", JOptionPane.ERROR_MESSAGE);
			}
			memoryStart.setText(null);
			memoryEnd.setText(null);
			value.setText(null);
		}
		if (source == closeButton)
		{
			dispose();
		}
	}

	public String getReturnValue()
	{
		return returnValue;
	}

	private CommandProcessor commandProcessor;
	private TopLevelWindow parent;
	private JTextField memoryStart;
	private JTextField memoryEnd;
	private JTextField value;
	private JButton applyButton;
	private JButton closeButton;
	private String returnValue;
}