package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.event.*;
import javax.swing.plaf.metal.MetalLookAndFeel;
import JIMSCore.*;

/**
  * A class representing the help window.
  *
  * @author Fred Williams
*/
public class HelpWindow extends JFrame implements HyperlinkListener, ActionListener
{
	private JButton backButton;
	private JButton contentsButton;
	private JButton closeButton;
	private Vector backList;
	private URL contentsURL;

	public HelpWindow(TopLevelWindow parent)
	{
		parentWindow = parent;
		backList = new Vector();

		contentsButton = new JButton("Contents");
		contentsButton.addActionListener(this);
		backButton = new JButton("Back");
		backButton.addActionListener(this);
		closeButton = new JButton("Close");
		closeButton.addActionListener(this);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(0,5,10,5)); 
		buttonPanel.add(contentsButton);
		buttonPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		buttonPanel.add(backButton);
		buttonPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		buttonPanel.add(closeButton);

		helpContents = new JEditorPane();
		helpContents.setEditorKit(new HTMLEditorKit());
		try
		{
			helpContents = new JEditorPane("file:." + System.getProperty("file.separator") + "help" + System.getProperty("file.separator") + "help.html");
			contentsURL = helpContents.getPage();
		}
		catch (IOException ioe)
		{
			System.err.println("Error opening help file in HelpWindow constructor.");
		}
		helpContents.setSelectionColor(MetalLookAndFeel.getWhite());
		helpContents.setEditable(false);			
		helpContents.addHyperlinkListener(this);
		scroller = new JScrollPane(helpContents, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scroller.getViewport().setScrollMode(JViewport.SIMPLE_SCROLL_MODE);

		JPanel intermediatePane = new JPanel();
		intermediatePane.setLayout(new BoxLayout(intermediatePane, BoxLayout.Y_AXIS));
		intermediatePane.add(buttonPanel);
		intermediatePane.add(scroller);

		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(intermediatePane, BorderLayout.CENTER);
		contentPane.add(new JPanel(), BorderLayout.NORTH);
		contentPane.add(new JPanel(), BorderLayout.SOUTH);
		contentPane.add(new JPanel(), BorderLayout.EAST);
		contentPane.add(new JPanel(), BorderLayout.WEST);

		setContentPane(contentPane);
		pack();
		setSize(parent.getWidth() / 2, parent.getHeight() / 2);
		setResizable(true);
		setLocation(new Point(parent.getX() + ((parent.getWidth()-this.getWidth()) / 2), parent.getY() + ((parent.getHeight()-this.getHeight()) / 2)));
		setTitle("JIMSwing Help");
		setVisible(true);
	}

	public void hyperlinkUpdate(HyperlinkEvent he)
	{
		if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
		{
			try
			{
				backList.addElement(helpContents.getPage());
				helpContents.setPage(he.getURL());
			}
			catch (Exception e)
			{
				System.err.println("Error opening html file in HelpWindow.hyperlinkUpdate.");
			}
		}
	}

	public void actionPerformed(ActionEvent ae)
	{
		Object source = ae.getSource();
		if (source == backButton)
		{
			if (backList.size() != 0)
			{
				URL target = (URL)backList.remove(backList.size() - 1);
				try
				{
					helpContents.setPage(target);
				}
				catch (Exception e)
				{
					System.err.println("Error opening html file in HelpWindow.hyperlinkUpdate.");
				}			
			}
		}
		if (source == contentsButton)
		{
			backList.addElement(helpContents.getPage());
			try
			{
				helpContents.setPage(contentsURL);
			}
			catch (IOException e)
			{

			}
		}
		if (source == closeButton)
		{
			dispose();
		}
	}
// ===================================================================================
// Private instance variables
// ===================================================================================
	private TopLevelWindow parentWindow;
	private JEditorPane helpContents;
	private JScrollPane scroller;
}

