package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import javax.swing.plaf.metal.MetalLookAndFeel;
import JIMSCore.*;

/**
  * A class representing the command console window.
  *
  * @author Fred Williams
*/
public class CommandConsoleWindow extends JFrame implements ActionListener
{
// ===================================================================================
// Initialization (frame constructor) method
// ===================================================================================
	public CommandConsoleWindow(TopLevelWindow parent, CommandProcessor cp)
	{
		parentWindow = parent;

		JLabel inputLabel = new JLabel("Input: ");
		inputLine = new JTextField();
		inputButton = new JButton("Process command");
		getRootPane().setDefaultButton(inputButton);
		inputButton.addActionListener(this);
		outputArea = new JTextArea();
		outputArea.setEditable(false);
		outputArea.setFont(new Font("monospaced", 0, 12));
		outputArea.append("> ");
		JScrollPane consolePane= new JScrollPane(outputArea, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		consolePane.getViewport().setScrollMode(JViewport.SIMPLE_SCROLL_MODE);
		
		commandProcessor = cp;

		inputPane = new JPanel();
		inputPane.setLayout(new BoxLayout(inputPane, BoxLayout.X_AXIS));
		inputPane.setBorder(BorderFactory.createEmptyBorder(10,5,10,5)); 
		inputPane.add(inputLabel);
		inputPane.add(inputLine);
		inputPane.add(inputButton);

		intermediatePane = new JPanel();
		intermediatePane.setLayout(new BorderLayout());
		intermediatePane.add(inputPane, BorderLayout.NORTH);
		intermediatePane.add(consolePane, BorderLayout.CENTER);

		contentPane = new JPanel();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(intermediatePane, BorderLayout.CENTER);
		contentPane.add(new JPanel(), BorderLayout.NORTH);
		contentPane.add(new JPanel(), BorderLayout.SOUTH);
		contentPane.add(new JPanel(), BorderLayout.EAST);
		contentPane.add(new JPanel(), BorderLayout.WEST);

		setContentPane(contentPane);
		pack();
		setSize(parent.getWidth() / 2, parent.getHeight() / 2);
		setResizable(true);
		setLocation(new Point(parent.getX() + ((parent.getWidth()-this.getWidth()) / 2), parent.getY() + ((parent.getHeight()-this.getHeight()) / 2)));
		setTitle("JIMSwing Command Console");
		setVisible(true);
	}

// ===================================================================================
// METHOD:		actionPerformed
// FUNCTION:	handles ActionEvent events
// ===================================================================================		
	public void actionPerformed(ActionEvent ae)
	{
		if (ae.getSource() == inputButton)
		{
			String userCommand = inputLine.getText();
			outputArea.append(userCommand + "\n");
			inputLine.setText(null);
			commandResultBuffer = commandProcessor.processCommand(userCommand);
			outputArea.append(commandResultBuffer.toString());
			outputArea.append("> ");
			validate();
			parentWindow.displayUpdate();
		}
	}

// ===================================================================================
// Private instance variables
// ===================================================================================
	private TopLevelWindow parentWindow;
	private JPanel contentPane;
	private JPanel inputPane;
	private JPanel intermediatePane;
	private JTextField inputLine;
	private JButton inputButton;
	private JTextArea outputArea;
	private CommandProcessor commandProcessor;
	private CommandResultBuffer commandResultBuffer;
}

